/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.admin.impl;

import java.net.URL;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.Version;
import net.shibboleth.idp.admin.impl.IdPInfo;
import net.shibboleth.profile.installablecomponent.InstallableComponentInfo;
import net.shibboleth.profile.installablecomponent.InstallableComponentSupport;
import net.shibboleth.profile.installablecomponent.InstallableComponentVersion;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.apache.hc.client5.http.classic.HttpClient;
import org.opensaml.security.httpclient.HttpClientSecurityParameters;
import org.slf4j.Logger;

public class ReportUpdateStatus
extends AbstractIdentifiableInitializableComponent
implements Runnable {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ReportUpdateStatus.class);
    @Nonnull
    private List<URL> updateUrls = CollectionSupport.emptyList();
    private boolean enabled;
    @NonnullAfterInit
    private HttpClient httpClient;
    @Nullable
    private HttpClientSecurityParameters securityParams;

    public void setUpdateUrls(@Nullable List<URL> urls) {
        if (urls == null || urls.isEmpty()) {
            this.log.error("Empty URL update list specified");
        } else {
            this.updateUrls = urls;
        }
    }

    public void setSecurityParams(@Nullable HttpClientSecurityParameters params) {
        this.securityParams = params;
    }

    public void setHttpClient(@Nonnull HttpClient client) {
        this.httpClient = (HttpClient)Constraint.isNotNull((Object)client, (String)"HttpClient cannot be null");
    }

    public void setEnabled(boolean on) {
        this.enabled = on;
    }

    protected void doInitialize() throws ComponentInitializationException {
        if (!this.enabled) {
            return;
        }
        if (this.httpClient == null) {
            throw new ComponentInitializationException("HttpClient was not set");
        }
        if (this.updateUrls.isEmpty()) {
            throw new ComponentInitializationException("No update URLs set");
        }
        ExecutorService svc = Executors.newSingleThreadExecutor();
        svc.execute(this);
        svc.shutdown();
    }

    @Override
    public void run() {
        try {
            String versionStr = Version.getVersion();
            if (versionStr == null) {
                this.log.warn("Could not find current IdP Version (likely operating inside IDE)");
                return;
            }
            InstallableComponentVersion version = new InstallableComponentVersion(versionStr);
            assert (this.httpClient != null);
            Properties properties = InstallableComponentSupport.loadInfo(this.updateUrls, (HttpClient)this.httpClient, (HttpClientSecurityParameters)this.securityParams);
            if (properties == null) {
                this.log.warn("Could not locate IdP update information");
                return;
            }
            IdPInfo info = new IdPInfo(properties);
            InstallableComponentVersion newIdPVersion = InstallableComponentSupport.getBestVersion((InstallableComponentVersion)version, (InstallableComponentVersion)version, (InstallableComponentInfo)info);
            if (newIdPVersion == null) {
                this.log.info("No upgrade available from {}", (Object)version);
            } else {
                this.log.warn("Version {} can be upgraded to {}", (Object)version, (Object)newIdPVersion);
            }
            InstallableComponentInfo.VersionInfo verInfo = (InstallableComponentInfo.VersionInfo)info.getAvailableVersions().get(version);
            if (verInfo == null) {
                this.log.warn("Could not locate version info for version {}", (Object)version);
            } else {
                InstallableComponentSupport.SupportLevel sl = verInfo.getSupportLevel();
                switch (sl) {
                    case Current: {
                        this.log.info("Version {} is current", (Object)version);
                        break;
                    }
                    case Secadv: {
                        this.log.error("Version {} has known security vulnerabilities", (Object)version);
                        break;
                    }
                    default: {
                        this.log.warn("Support level for {} is {}", (Object)version, (Object)sl);
                    }
                }
            }
        }
        catch (Throwable t) {
            this.log.error("Check for update status failed unexpectedly", t);
        }
    }
}

