/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.admin.impl;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.json.MetricsModule;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.util.JSONPObject;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.context.SpringRequestContext;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.springframework.webflow.execution.RequestContext;

public class OutputMetrics
extends AbstractProfileAction {
    @Nonnull
    @NotEmpty
    public static final String ALL_METRICS = "all";
    @Nonnull
    @NotEmpty
    public static final String METRIC_ID = "metricId";
    @Nonnull
    private Logger log = LoggerFactory.getLogger(OutputMetrics.class);
    @Nullable
    private MetricFilter metricFilter;
    @NonnullAfterInit
    private MetricRegistry metricRegistry;
    @Nullable
    private String allowedOrigin;
    @Nullable
    private String jsonpCallbackName;
    @NonnullAfterInit
    private DateTimeFormatter dateTimeFormatter;
    private boolean useDefaultTimeZone;
    @Nonnull
    private Map<String, MetricFilter> metricFilterMap = CollectionSupport.emptyMap();
    @NonnullBeforeExec
    private String metricId;

    public OutputMetrics() {
        DateTimeFormatter instant = DateTimeFormatter.ISO_INSTANT;
        assert (instant != null);
        this.dateTimeFormatter = instant;
    }

    public void setMetricFilter(@Nullable MetricFilter filter) {
        this.checkSetterPreconditions();
        this.metricFilter = filter;
    }

    public void setMetricRegistry(@Nonnull MetricRegistry registry) {
        this.checkSetterPreconditions();
        this.metricRegistry = (MetricRegistry)Constraint.isNotNull((Object)registry, (String)"MetricRegistry cannot be null");
    }

    public void setAllowedOrigin(@Nullable String origin) {
        this.checkSetterPreconditions();
        this.allowedOrigin = StringSupport.trimOrNull((String)origin);
    }

    public void setJSONPCallbackName(@Nullable String callbackName) {
        this.checkSetterPreconditions();
        this.jsonpCallbackName = StringSupport.trimOrNull((String)callbackName);
    }

    public void setDateTimeFormat(@Nullable @NotEmpty String format) {
        this.checkSetterPreconditions();
        if (format != null) {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(StringSupport.trimOrNull((String)format));
            assert (formatter != null);
            this.dateTimeFormatter = formatter;
        }
    }

    public void setUseDefaultTimeZone(boolean flag) {
        this.checkSetterPreconditions();
        this.useDefaultTimeZone = flag;
    }

    public void setMetricFilterMap(@Nonnull Map<String, MetricFilter> map) {
        this.checkSetterPreconditions();
        Constraint.isNotNull(map, (String)"MetricFilter map cannot be null");
        this.metricFilterMap = new HashMap<String, MetricFilter>(map.size());
        for (Map.Entry<String, MetricFilter> entry : map.entrySet()) {
            String trimmed = StringSupport.trimOrNull((String)entry.getKey());
            if (trimmed == null || entry.getValue() == null) continue;
            this.metricFilterMap.put(trimmed, entry.getValue());
        }
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.metricRegistry == null) {
            throw new ComponentInitializationException("MetricRegistry cannot be null");
        }
        DateTimeFormatter formatter = this.useDefaultTimeZone ? this.dateTimeFormatter.withZone(ZoneId.systemDefault()) : this.dateTimeFormatter.withZone(ZoneOffset.UTC);
        assert (formatter != null);
        this.dateTimeFormatter = formatter;
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        SpringRequestContext springRequestContext = (SpringRequestContext)profileRequestContext.getSubcontext(SpringRequestContext.class);
        if (springRequestContext == null) {
            this.log.warn("{} Spring request context not found in profile request context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        RequestContext requestContext = springRequestContext.getRequestContext();
        if (requestContext == null) {
            this.log.warn("{} Web Flow request context not found in Spring request context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        HttpServletResponse response = this.getHttpServletResponse();
        if (response == null) {
            this.log.warn("{} No HttpServletResponse available", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        this.metricId = (String)requestContext.getFlowScope().get(METRIC_ID);
        if (this.metricId == null) {
            this.log.warn("{} No {} flow variable found in request", (Object)this.getLogPrefix(), (Object)METRIC_ID);
            try {
                response.sendError(404);
            }
            catch (IOException e) {
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InputOutputError");
            }
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        MetricFilter filter;
        MetricFilter metricFilter = filter = ALL_METRICS.equals(this.metricId) ? MetricFilter.ALL : this.metricFilterMap.get(this.metricId);
        if (filter == null) {
            filter = new MetricFilter(){

                public boolean matches(String name, Metric metric) {
                    return name.equals(OutputMetrics.this.metricId);
                }
            };
        }
        filter = new ChainedMetricFilter(filter);
        try {
            HttpServletResponse response = this.getHttpServletResponse();
            assert (response != null);
            response.setHeader("Cache-Control", "must-revalidate,no-cache,no-store");
            response.setStatus(200);
            if (this.allowedOrigin != null) {
                response.setHeader("Access-Control-Allow-Origin", this.allowedOrigin);
            }
            ObjectMapper mapper = new ObjectMapper().registerModule((Module)new MetricsModule(TimeUnit.SECONDS, TimeUnit.SECONDS, true, filter));
            JavaTimeModule javatime = new JavaTimeModule();
            javatime.addSerializer(Instant.class, (JsonSerializer)new JsonSerializer<Instant>(){

                public void serialize(Instant value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                    gen.writeString(OutputMetrics.this.dateTimeFormatter.format(value));
                }
            });
            mapper.registerModule((Module)javatime);
            mapper.configure(SerializationFeature.WRITE_DURATIONS_AS_TIMESTAMPS, false);
            mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
            mapper.configure(SerializationFeature.WRITE_DATE_TIMESTAMPS_AS_NANOSECONDS, false);
            if (this.jsonpCallbackName != null) {
                response.setContentType("application/javascript");
                mapper.writer().writeValue((OutputStream)response.getOutputStream(), (Object)new JSONPObject(this.jsonpCallbackName, (Object)this.metricRegistry));
            } else {
                response.setContentType("application/json");
                mapper.writer().writeValue((OutputStream)response.getOutputStream(), (Object)this.metricRegistry);
            }
        }
        catch (IOException e) {
            this.log.error("{} I/O error responding to request", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InputOutputError");
        }
    }

    private class ChainedMetricFilter
    implements MetricFilter {
        @Nonnull
        private final MetricFilter parentFilter;

        public ChainedMetricFilter(MetricFilter parent) {
            this.parentFilter = parent;
        }

        public boolean matches(String name, Metric metric) {
            return this.parentFilter.matches(name, metric) && OutputMetrics.this.metricFilter != null && OutputMetrics.this.metricFilter.matches(name, metric);
        }
    }
}

