/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.admin.impl;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.jasminb.jsonapi.models.errors.Error;
import com.github.jasminb.jsonapi.models.errors.Errors;
import com.google.common.base.Strings;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.context.SpringRequestContext;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.storage.StorageRecord;
import org.opensaml.storage.StorageService;
import org.opensaml.storage.VersionMismatchException;
import org.slf4j.Logger;
import org.springframework.webflow.execution.RequestContext;

public class DoStorageOperation
extends AbstractProfileAction {
    @Nonnull
    @NotEmpty
    public static final String SERVICE_ID = "storageServiceId";
    @Nonnull
    @NotEmpty
    public static final String CONTEXT = "context";
    @Nonnull
    @NotEmpty
    public static final String KEY = "key";
    @Nonnull
    private Logger log = LoggerFactory.getLogger(DoStorageOperation.class);
    @NonnullAfterInit
    private ObjectMapper objectMapper;
    @NonnullBeforeExec
    private StorageService storageService;
    @NonnullBeforeExec
    @NotEmpty
    private String context;
    @NonnullBeforeExec
    @NotEmpty
    private String key;

    public void setObjectMapper(@Nonnull ObjectMapper mapper) {
        this.checkSetterPreconditions();
        this.objectMapper = (ObjectMapper)Constraint.isNotNull((Object)mapper, (String)"ObjectMapper cannot be null");
    }

    public void setStorageService(@Nullable StorageService storage) {
        this.checkSetterPreconditions();
        this.storageService = storage;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.objectMapper == null) {
            throw new ComponentInitializationException("ObjectMapper cannot be null");
        }
    }

    @Nonnull
    private String getKey() {
        assert (this.isPreExecuteCalled());
        return this.key;
    }

    @Nonnull
    private String getContext() {
        assert (this.isPreExecuteCalled());
        return this.context;
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        if (this.getHttpServletRequest() == null || this.getHttpServletResponse() == null) {
            this.log.warn("{} No HttpServletRequest or HttpServletResponse available", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        try {
            SpringRequestContext springRequestContext = (SpringRequestContext)profileRequestContext.getSubcontext(SpringRequestContext.class);
            if (springRequestContext == null) {
                this.log.warn("{} Spring request context not found in profile request context", (Object)this.getLogPrefix());
                this.sendError(500, "Internal Server Error", "System misconfiguration.");
                return false;
            }
            RequestContext requestContext = springRequestContext.getRequestContext();
            if (requestContext == null) {
                this.log.warn("{} Web Flow request context not found in Spring request context", (Object)this.getLogPrefix());
                this.sendError(500, "Internal Server Error", "System misconfiguration.");
                return false;
            }
            if (this.storageService == null) {
                this.storageService = this.getStorageService(requestContext);
                if (this.storageService == null) {
                    this.sendError(404, "Invalid Storage Service", "Invalid storage service identifier in path.");
                    return false;
                }
            }
            this.context = (String)requestContext.getFlowScope().get(CONTEXT);
            this.key = (String)requestContext.getFlowScope().get(KEY);
            if (Strings.isNullOrEmpty((String)this.context) || Strings.isNullOrEmpty((String)this.key)) {
                this.sendError(404, "Missing Context or Key", "No context or key specified.");
                return false;
            }
        }
        catch (IOException e) {
            this.log.error("{} I/O error issuing API response", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InputOutputError");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        try {
            HttpServletRequest request = this.ensureHttpServletRequest();
            HttpServletResponse response = this.ensureHttpServletResponse();
            response.setContentType("application/json");
            response.setHeader("Cache-Control", "must-revalidate,no-cache,no-store");
            if ("GET".equals(request.getMethod())) {
                this.doRead();
            } else if ("PUT".equals(request.getMethod())) {
                this.doCreate();
            } else if ("POST".equals(request.getMethod())) {
                this.doUpdate();
            } else if ("DELETE".equals(request.getMethod())) {
                this.doDelete();
            } else {
                this.log.warn("{} Invalid method: {}", (Object)this.getLogPrefix(), (Object)request.getMethod());
                this.sendError(405, "Unknown Operation", "GET, PUT, POST, DELETE are supported.");
            }
        }
        catch (IOException e) {
            this.log.error("{} I/O error responding to request", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InputOutputError");
        }
    }

    @Nullable
    private StorageService getStorageService(@Nonnull RequestContext requestContext) {
        String id = (String)requestContext.getFlowScope().get(SERVICE_ID);
        if (id == null) {
            this.log.warn("{} No {} flow variable found in request", (Object)this.getLogPrefix(), (Object)SERVICE_ID);
            return null;
        }
        return (StorageService)this.getBean(requestContext, id, StorageService.class);
    }

    private void doRead() throws IOException {
        block10: {
            try {
                StorageService storageServ = (StorageService)Constraint.isNotNull((Object)this.storageService, (String)"Null storge service not detected in preExecute");
                HttpServletResponse response = (HttpServletResponse)Constraint.isNotNull((Object)this.getHttpServletResponse(), (String)"No Servlet response present");
                StorageRecord record = storageServ.read(this.getContext(), this.getKey());
                if (record != null) {
                    response.setStatus(200);
                    JsonFactory jsonFactory = new JsonFactory();
                    try (JsonGenerator g = jsonFactory.createGenerator((OutputStream)response.getOutputStream()).useDefaultPrettyPrinter();){
                        g.setCodec((ObjectCodec)this.objectMapper);
                        g.writeStartObject();
                        g.writeObjectFieldStart("data");
                        g.writeStringField("type", "records");
                        g.writeStringField("id", storageServ.getId() + "/" + this.context + "/" + this.key);
                        g.writeObjectFieldStart("attributes");
                        g.writeStringField("value", record.getValue());
                        g.writeNumberField("version", record.getVersion());
                        if (record.getExpiration() != null) {
                            g.writeFieldName("expiration");
                            g.writeObject((Object)record.getExpiration());
                        }
                        break block10;
                    }
                }
                this.sendError(404, "Record Not Found", "The specified record was not present or has expired.");
            }
            catch (IOException e) {
                this.sendError(500, "Internal Server Error", "Storage error.");
            }
        }
    }

    private void doCreate() throws IOException {
        StorageService storageServ = (StorageService)Constraint.isNotNull((Object)this.storageService, (String)"Null storge service not detected in preExecute");
        HttpServletRequest request = this.ensureHttpServletRequest();
        HttpServletResponse response = this.ensureHttpServletResponse();
        JsonFactory jsonFactory = new JsonFactory();
        JsonParser parser = jsonFactory.createParser((InputStream)request.getInputStream());
        if (parser.nextToken() != JsonToken.START_OBJECT) {
            throw new IOException("Expected data to start with an Object");
        }
        String value = null;
        Long exp = null;
        while (parser.nextToken() != JsonToken.END_OBJECT) {
            String fieldName = parser.getCurrentName();
            parser.nextToken();
            if ("value".equals(fieldName)) {
                value = parser.getText();
                continue;
            }
            if (!"expiration".equals(fieldName)) continue;
            exp = parser.getLongValue();
        }
        if (value == null) {
            throw new IOException("Input missing 'val' field");
        }
        if (storageServ.create(this.getContext(), this.getKey(), value, exp)) {
            response.setStatus(201);
        } else {
            this.sendError(409, "Duplicate Record", "Context and key matched an existing record.");
        }
    }

    private void doUpdate() throws IOException {
        block14: {
            JsonFactory jsonFactory = new JsonFactory();
            StorageService storageServ = (StorageService)Constraint.isNotNull((Object)this.storageService, (String)"Null storge service not detected in preExecute");
            HttpServletRequest request = this.ensureHttpServletRequest();
            HttpServletResponse response = this.ensureHttpServletResponse();
            JsonParser parser = jsonFactory.createParser((InputStream)request.getInputStream());
            if (parser.nextToken() != JsonToken.START_OBJECT) {
                throw new IOException("Expected data to start with an Object");
            }
            String value = null;
            Long version = null;
            Long exp = null;
            while (parser.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = parser.getCurrentName();
                parser.nextToken();
                if ("value".equals(fieldName)) {
                    value = parser.getText();
                    continue;
                }
                if ("expiration".equals(fieldName)) {
                    exp = parser.getLongValue();
                    continue;
                }
                if (!"version".equals(fieldName)) continue;
                version = parser.getLongValue();
            }
            if (value == null) {
                throw new IOException("Input missing 'value' field");
            }
            if (version != null) {
                try {
                    version = storageServ.updateWithVersion(version.longValue(), this.getContext(), this.getKey(), value, exp);
                    if (version != null) {
                        response.setStatus(200);
                        break block14;
                    }
                    this.sendError(404, "Not Found", "Record to update was absent.");
                }
                catch (VersionMismatchException e) {
                    this.sendError(409, "Version Mismatch", "Record version did not match.");
                }
            } else if (storageServ.update(this.getContext(), this.getKey(), value, exp)) {
                response.setStatus(200);
            } else if (storageServ.create(this.getContext(), this.getKey(), value, exp)) {
                response.setStatus(201);
            } else {
                this.sendError(500, "Internal Server Error", "Record to update was absent and create attempt failed.");
            }
        }
    }

    private void doDelete() throws IOException {
        try {
            StorageService storageServ = (StorageService)Constraint.isNotNull((Object)this.storageService, (String)"Null storge service not detected in preExecute");
            HttpServletResponse response = this.ensureHttpServletResponse();
            if (storageServ.delete(this.getContext(), this.getKey())) {
                response.setStatus(204);
            } else {
                this.sendError(404, "Record Not Found", "The specified record was not present or has expired.");
            }
        }
        catch (IOException e) {
            this.sendError(500, "Internal Server Error", "Storage error.");
        }
    }

    private void sendError(int status, @Nonnull @NotEmpty String title, @Nonnull @NotEmpty String detail) throws IOException {
        HttpServletResponse response = this.ensureHttpServletResponse();
        response.setContentType("application/json");
        response.setHeader("Cache-Control", "must-revalidate,no-cache,no-store");
        response.setStatus(status);
        Error e = new Error();
        Errors errors = new Errors();
        errors.setErrors(CollectionSupport.singletonList((Object)e));
        e.setStatus(Integer.toString(status));
        e.setTitle(title);
        e.setDetail(detail);
        this.objectMapper.writer().withDefaultPrettyPrinter().writeValue((OutputStream)response.getOutputStream(), (Object)errors);
    }
}

