/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.ui.taglib;

import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspWriter;
import jakarta.servlet.jsp.tagext.BodyContent;
import java.io.IOException;
import java.io.Writer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.ui.context.RelyingPartyUIContext;
import net.shibboleth.idp.ui.taglib.ServiceTagSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

public class OrganizationURLTag
extends ServiceTagSupport {
    private static final long serialVersionUID = 5633365955540356312L;
    @Nonnull
    private static Logger log = LoggerFactory.getLogger(OrganizationURLTag.class);
    @Nullable
    private static String linkText;

    public void setLinkText(String text) {
        linkText = text;
    }

    @Nullable
    private String getOrganizationURL() {
        RelyingPartyUIContext ctx = this.getRelyingPartyUIContext();
        if (ctx == null) {
            return null;
        }
        return ctx.getOrganizationURL();
    }

    public int doEndTag() throws JspException {
        String orgURL = this.getOrganizationURL();
        try {
            if (null == orgURL) {
                JspWriter ew;
                BodyContent bc = this.getBodyContent();
                if (null != bc && (ew = bc.getEnclosingWriter()) != null) {
                    bc.writeOut((Writer)ew);
                }
            } else {
                this.pageContext.getOut().print(this.buildHyperLink(orgURL, linkText));
            }
        }
        catch (IOException e) {
            log.warn("Error generating OrganizationURL: {}", (Object)e.getMessage());
            throw new JspException("EndTag", (Throwable)e);
        }
        return super.doEndTag();
    }
}

