/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.profile.spring.impl;

import com.codahale.metrics.MetricRegistry;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.xml.ParserPool;
import org.opensaml.core.config.ConfigurationPropertiesSource;
import org.opensaml.core.config.ConfigurationService;
import org.opensaml.core.config.InitializationException;
import org.opensaml.core.config.InitializationService;
import org.opensaml.core.xml.config.XMLObjectProviderRegistry;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.spring.config.SpringConfigurationPropertiesSource;
import org.opensaml.xmlsec.config.DecryptionParserPool;
import org.slf4j.Logger;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;

public class OpenSAMLConfigBean
extends AbstractInitializableComponent
implements EnvironmentAware {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(OpenSAMLConfigBean.class);
    @Nullable
    private Environment springEnvironment;
    @Nullable
    private ParserPool parserPool;
    @Nullable
    private ParserPool decryptionParserPool;
    @Nullable
    private MetricRegistry metricRegistry;
    @Nullable
    private Map<String, Class<? extends BaseContext>> contextLookAsideMap;

    public void setEnvironment(@Nullable Environment environment) {
        this.checkSetterPreconditions();
        this.springEnvironment = environment;
    }

    @Nullable
    public ParserPool getParserPool() {
        return this.parserPool;
    }

    public void setParserPool(@Nullable ParserPool newParserPool) {
        this.checkSetterPreconditions();
        this.parserPool = newParserPool;
    }

    @Nullable
    public ParserPool getDecryptionParserPool() {
        return this.decryptionParserPool;
    }

    public void setDecryptionParserPool(@Nullable ParserPool newParserPool) {
        this.checkSetterPreconditions();
        this.decryptionParserPool = newParserPool;
    }

    @Nullable
    public MetricRegistry getMetricRegistry() {
        return this.metricRegistry;
    }

    public void setMetricRegistry(@Nullable MetricRegistry registry) {
        this.metricRegistry = registry;
    }

    public void setContextLookAsideMap(@Nullable Map<String, Class<? extends BaseContext>> map) {
        this.checkSetterPreconditions();
        this.contextLookAsideMap = map != null ? CollectionSupport.copyToMap(map) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doInitialize() throws ComponentInitializationException {
        if (this.springEnvironment != null) {
            ConfigurationService.setDefaultConfigurationPropertiesSource((ConfigurationPropertiesSource)new SpringConfigurationPropertiesSource((PropertyResolver)this.springEnvironment));
        }
        try {
            InitializationService.initialize();
        }
        catch (InitializationException e) {
            throw new ComponentInitializationException("Exception initializing OpenSAML", (Exception)((Object)e));
        }
        XMLObjectProviderRegistry registry = null;
        Class<ConfigurationService> clazz = ConfigurationService.class;
        synchronized (ConfigurationService.class) {
            if (this.metricRegistry != null) {
                ConfigurationService.register(MetricRegistry.class, (Object)this.metricRegistry);
            }
            if ((registry = (XMLObjectProviderRegistry)ConfigurationService.get(XMLObjectProviderRegistry.class)) == null) {
                this.log.debug("XMLObjectProviderRegistry did not exist in ConfigurationService, will be created");
                registry = new XMLObjectProviderRegistry();
                ConfigurationService.register(XMLObjectProviderRegistry.class, (Object)registry);
            }
            // ** MonitorExit[var2_3] (shouldn't be in output)
            if (this.parserPool != null) {
                registry.setParserPool(this.parserPool);
            }
            if (this.decryptionParserPool != null) {
                ConfigurationService.register(DecryptionParserPool.class, (Object)new DecryptionParserPool(this.decryptionParserPool));
            }
            if (this.contextLookAsideMap != null) {
                ConfigurationService.register(BaseContext.DeprecatedContextClassNameLookAside.class, (Object)new BaseContext.DeprecatedContextClassNameLookAside(this.contextLookAsideMap));
            }
            return;
        }
    }
}

