/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.profile.relyingparty.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.profile.relyingparty.RelyingPartyConfiguration;
import net.shibboleth.profile.relyingparty.RelyingPartyConfigurationResolver;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.AbstractIdentifiedInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.component.IdentifiableComponent;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.Criterion;
import net.shibboleth.shared.resolver.Resolver;
import net.shibboleth.shared.resolver.ResolverException;
import net.shibboleth.shared.service.ReloadableService;
import net.shibboleth.shared.service.ServiceException;
import net.shibboleth.shared.service.ServiceableComponent;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.criterion.ProfileRequestContextCriterion;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.criterion.RoleDescriptorCriterion;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.slf4j.Logger;

public class CriteriaSelfEntityIDResolver
extends AbstractIdentifiedInitializableComponent
implements Resolver<String, CriteriaSet>,
IdentifiableComponent {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(CriteriaSelfEntityIDResolver.class);
    @NonnullAfterInit
    private ReloadableService<RelyingPartyConfigurationResolver> rpcResolver;

    public void setRelyingPartyConfigurationResolver(@Nullable ReloadableService<RelyingPartyConfigurationResolver> resolver) {
        this.checkSetterPreconditions();
        this.rpcResolver = resolver;
    }

    public void setId(@Nonnull @NotEmpty String componentId) {
        super.setId(componentId);
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.rpcResolver == null) {
            throw new ComponentInitializationException("RelyingPartyConfigurationResolver cannot be null");
        }
    }

    protected void doDestroy() {
        this.rpcResolver = null;
        super.doDestroy();
    }

    @Nonnull
    public Iterable<String> resolve(@Nullable CriteriaSet criteria) throws ResolverException {
        this.checkComponentActive();
        String entityID = this.resolveSingle(criteria);
        if (entityID != null) {
            return CollectionSupport.singletonList((Object)entityID);
        }
        return CollectionSupport.emptyList();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public String resolveSingle(@Nullable CriteriaSet criteria) throws ResolverException {
        this.checkComponentActive();
        ProfileRequestContext prc = this.buildContext(criteria);
        if (prc == null) {
            this.log.error("Unable to extract or build ProfileRequestContext for resolution");
            return null;
        }
        CriteriaSet prcSet = new CriteriaSet(new Criterion[]{new ProfileRequestContextCriterion(prc)});
        try (ServiceableComponent resolver = this.rpcResolver.getServiceableComponent();){
            RelyingPartyConfiguration rpc = (RelyingPartyConfiguration)((RelyingPartyConfigurationResolver)resolver.getComponent()).resolveSingle((Object)prcSet);
            if (rpc != null) {
                String string = rpc.getIssuer(prc);
                return string;
            }
            this.log.error("RelyingPartyConfigurationResolver returned null configuration");
            return null;
        }
        catch (ResolverException e) {
            this.log.error("RelyingPartyConfigurationResolver did not resolve a RelyingPartyConfiguration: {}", (Object)e.getMessage());
            return null;
        }
        catch (ServiceException e) {
            this.log.error("RelyingPartyConfiguration resolver unvailable: {}", (Object)e.getMessage());
        }
        return null;
    }

    @Nullable
    private ProfileRequestContext buildContext(@Nullable CriteriaSet criteria) {
        if (criteria == null) {
            return null;
        }
        ProfileRequestContextCriterion prcCriterion = (ProfileRequestContextCriterion)criteria.get(ProfileRequestContextCriterion.class);
        if (prcCriterion != null) {
            return prcCriterion.getProfileRequestContext();
        }
        String entityID = this.resolveEntityID(criteria);
        this.log.debug("Resolved effective entityID from criteria: {}", (Object)entityID);
        EntityDescriptor entityDescriptor = this.resolveEntityDescriptor(criteria);
        this.log.debug("Resolved effective entity descriptor from criteria: {}", (Object)entityDescriptor);
        RoleDescriptor roleDescriptor = this.resolveRoleDescriptor(criteria);
        this.log.debug("Resolved effective role descriptor from criteria: {}", (Object)roleDescriptor);
        if (entityID != null || entityDescriptor != null || roleDescriptor != null) {
            ProfileRequestContext prc = new ProfileRequestContext();
            RelyingPartyContext rpc = (RelyingPartyContext)prc.ensureSubcontext(RelyingPartyContext.class);
            rpc.setVerified(Boolean.valueOf(true));
            rpc.setRelyingPartyId(entityID);
            if (entityDescriptor != null || roleDescriptor != null) {
                SAMLPeerEntityContext peerContext = (SAMLPeerEntityContext)prc.ensureSubcontext(SAMLPeerEntityContext.class);
                rpc.setRelyingPartyIdContextTree((BaseContext)peerContext);
                peerContext.setEntityId(entityID);
                if (roleDescriptor != null) {
                    peerContext.setRole(roleDescriptor.getSchemaType() != null ? roleDescriptor.getSchemaType() : roleDescriptor.getElementQName());
                }
                SAMLMetadataContext metadataContext = (SAMLMetadataContext)peerContext.ensureSubcontext(SAMLMetadataContext.class);
                metadataContext.setEntityDescriptor(entityDescriptor);
                metadataContext.setRoleDescriptor(roleDescriptor);
            }
            return prc;
        }
        return null;
    }

    @Nullable
    private String resolveEntityID(@Nonnull CriteriaSet criteria) {
        EntityIdCriterion eic = (EntityIdCriterion)criteria.get(EntityIdCriterion.class);
        if (eic != null) {
            return eic.getEntityId();
        }
        EntityDescriptor ed = this.resolveEntityDescriptor(criteria);
        if (ed != null) {
            return ed.getEntityID();
        }
        return null;
    }

    @Nullable
    private EntityDescriptor resolveEntityDescriptor(@Nonnull CriteriaSet criteria) {
        RoleDescriptor rd = this.resolveRoleDescriptor(criteria);
        if (rd != null && rd.getParent() != null && rd.getParent() instanceof EntityDescriptor) {
            return (EntityDescriptor)rd.getParent();
        }
        return null;
    }

    @Nullable
    private RoleDescriptor resolveRoleDescriptor(@Nonnull CriteriaSet criteria) {
        RoleDescriptorCriterion rdc = (RoleDescriptorCriterion)criteria.get(RoleDescriptorCriterion.class);
        if (rdc != null) {
            return rdc.getRole();
        }
        return null;
    }
}

