/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.revocation.impl;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.jasminb.jsonapi.models.errors.Error;
import com.github.jasminb.jsonapi.models.errors.Errors;
import com.google.common.base.Strings;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.time.Duration;
import javax.annotation.Nonnull;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.context.SpringRequestContext;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.xml.DOMTypeSupport;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.storage.RevocationCache;
import org.slf4j.Logger;
import org.springframework.webflow.execution.RequestContext;

public class DoRevocationCacheOperation
extends AbstractProfileAction {
    @Nonnull
    @NotEmpty
    public static final String CACHE_ID = "revocationCacheId";
    @Nonnull
    @NotEmpty
    public static final String CONTEXT = "context";
    @Nonnull
    @NotEmpty
    public static final String KEY = "key";
    @Nonnull
    private Logger log = LoggerFactory.getLogger(DoRevocationCacheOperation.class);
    @NonnullAfterInit
    private ObjectMapper objectMapper;
    @NonnullBeforeExec
    @NotEmpty
    private String cacheId;
    @NonnullBeforeExec
    @NotEmpty
    private String context;
    @NonnullBeforeExec
    @NotEmpty
    private String key;
    @NonnullBeforeExec
    private RevocationCache revocationCache;

    public void setObjectMapper(@Nonnull ObjectMapper mapper) {
        this.checkSetterPreconditions();
        this.objectMapper = (ObjectMapper)Constraint.isNotNull((Object)mapper, (String)"ObjectMapper cannot be null");
    }

    @Nonnull
    private RevocationCache getRevocationCache() {
        assert (this.isPreExecuteCalled());
        assert (this.revocationCache != null);
        return this.revocationCache;
    }

    @Nonnull
    private String getCacheId() {
        assert (this.isPreExecuteCalled());
        assert (this.cacheId != null);
        return this.cacheId;
    }

    @Nonnull
    private String getKey() {
        assert (this.isPreExecuteCalled());
        assert (this.key != null);
        return this.key;
    }

    @Nonnull
    private String getContext() {
        assert (this.isPreExecuteCalled());
        assert (this.context != null);
        return this.context;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.objectMapper == null) {
            throw new ComponentInitializationException("ObjectMapper cannot be null");
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        if (this.getHttpServletRequest() == null || this.getHttpServletResponse() == null) {
            this.log.warn("{} No HttpServletRequest or HttpServletResponse available", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        try {
            SpringRequestContext springRequestContext = (SpringRequestContext)profileRequestContext.getSubcontext(SpringRequestContext.class);
            if (springRequestContext == null) {
                this.log.warn("{} Spring request context not found in profile request context", (Object)this.getLogPrefix());
                this.sendError(500, "Internal Server Error", "System misconfiguration.");
                return false;
            }
            RequestContext requestContext = springRequestContext.getRequestContext();
            if (requestContext == null) {
                this.log.warn("{} Web Flow request context not found in Spring request context", (Object)this.getLogPrefix());
                this.sendError(500, "Internal Server Error", "System misconfiguration.");
                return false;
            }
            String cId = this.cacheId = (String)this.getParameter(requestContext, CACHE_ID);
            this.context = (String)this.getParameter(requestContext, CONTEXT);
            this.key = (String)this.getParameter(requestContext, KEY);
            if (Strings.isNullOrEmpty((String)cId) || Strings.isNullOrEmpty((String)this.context) || Strings.isNullOrEmpty((String)this.key)) {
                this.sendError(404, "Missing revocation cache ID, context, or key", "No revocation cache ID, context, key specified.");
                return false;
            }
            assert (cId != null);
            this.revocationCache = (RevocationCache)this.getBean(requestContext, cId, RevocationCache.class);
            if (this.revocationCache == null) {
                this.sendError(404, "Invalid Revocation Cache", "Invalid revocation cache identifier in path.");
                return false;
            }
        }
        catch (IOException e) {
            this.log.error("{} I/O error issuing API response", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InputOutputError");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        try {
            HttpServletRequest request = this.getHttpServletRequest();
            HttpServletResponse response = this.getHttpServletResponse();
            assert (request != null && response != null);
            String method = request.getMethod();
            response.setContentType("application/json");
            response.setHeader("Cache-Control", "must-revalidate,no-cache,no-store");
            if ("GET".equals(method)) {
                this.doGet();
            } else if ("POST".equals(method) || "PUT".equals(method)) {
                this.doPost();
            } else if ("DELETE".equals(method)) {
                this.doDelete();
            } else {
                this.log.warn("{} Invalid method: {}", (Object)this.getLogPrefix(), (Object)method);
                this.sendError(405, "Unknown Operation", "Only GET, POST, and DELETE are supported.");
            }
        }
        catch (IOException e) {
            this.log.error("{} I/O error responding to request", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InputOutputError");
        }
    }

    private void doGet() throws IOException {
        block11: {
            try {
                assert (this.revocationCache != null && this.context != null && this.key != null);
                String revocation = this.revocationCache.getRevocationRecord(this.context, this.key);
                HttpServletRequest request = this.getHttpServletRequest();
                HttpServletResponse response = this.getHttpServletResponse();
                assert (request != null && response != null);
                if (revocation != null) {
                    response.setStatus(200);
                    JsonFactory jsonFactory = new JsonFactory();
                    try (JsonGenerator g = jsonFactory.createGenerator((OutputStream)response.getOutputStream()).useDefaultPrettyPrinter();){
                        g.setCodec((ObjectCodec)this.objectMapper);
                        g.writeStartObject();
                        g.writeObjectFieldStart("data");
                        g.writeStringField("type", "revocation-records");
                        g.writeStringField("id", this.getCacheId() + "/" + this.context + "/" + this.key);
                        g.writeObjectFieldStart("attributes");
                        g.writeStringField("revocation", revocation);
                        break block11;
                    }
                }
                response.setStatus(404);
            }
            catch (IOException e) {
                this.sendError(500, "Internal Server Error", "Revocation cache error.");
            }
        }
    }

    private void doPost() throws IOException {
        boolean result;
        HttpServletRequest request = this.getHttpServletRequest();
        HttpServletResponse response = this.getHttpServletResponse();
        assert (request != null && response != null);
        String value = request.getParameter("value");
        String duration = request.getParameter("duration");
        if (value == null) {
            this.sendError(400, "Bad Request", "Request missing value parameter.");
            return;
        }
        Duration durationSeconds = null;
        if (duration != null) {
            if (duration.startsWith("P")) {
                durationSeconds = DOMTypeSupport.stringToDuration((String)duration);
            } else {
                try {
                    durationSeconds = Duration.ofSeconds(Long.valueOf(duration));
                }
                catch (NumberFormatException e) {
                    this.sendError(400, "Bad Request", "Duration parameter was not a long integer.");
                    return;
                }
            }
        }
        if (result = durationSeconds != null ? this.getRevocationCache().revoke(this.getContext(), this.getKey(), value, durationSeconds) : this.getRevocationCache().revoke(this.getContext(), this.getKey(), value)) {
            response.setStatus(202);
        } else {
            this.sendError(500, "Internal Server Error", "Attempt to insert revocation record failed.");
        }
    }

    private void doDelete() throws IOException {
        HttpServletResponse response = this.getHttpServletResponse();
        assert (response != null);
        if (this.getRevocationCache().unrevoke(this.getContext(), this.getKey())) {
            response.setStatus(204);
        } else {
            response.setStatus(404);
        }
    }

    private void sendError(int status, @Nonnull @NotEmpty String title, @Nonnull @NotEmpty String detail) throws IOException {
        HttpServletResponse response = this.getHttpServletResponse();
        assert (response != null);
        response.setContentType("application/json");
        response.setHeader("Cache-Control", "must-revalidate,no-cache,no-store");
        response.setStatus(status);
        Error e = new Error();
        Errors errors = new Errors();
        errors.setErrors(CollectionSupport.singletonList((Object)e));
        e.setStatus(Integer.toString(status));
        e.setTitle(title);
        e.setDetail(detail);
        this.objectMapper.writer().withDefaultPrettyPrinter().writeValue((OutputStream)response.getOutputStream(), (Object)errors);
    }
}

