/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.resource.Resource;
import org.ldaptive.ssl.CredentialConfig;
import org.ldaptive.ssl.SSLContextInitializer;
import org.ldaptive.ssl.X509SSLContextInitializer;
import org.opensaml.security.crypto.KeySupport;
import org.opensaml.security.x509.X509Support;

public class X509ResourceCredentialConfig
implements CredentialConfig {
    @Nullable
    private Resource trustCertificates;
    @Nullable
    private Resource authenticationCertificate;
    @Nullable
    private Resource authenticationKey;
    @Nullable
    private String authenticationKeyPassword;

    public void setTrustCertificates(@Nonnull @NotEmpty Resource resource) {
        this.trustCertificates = (Resource)Constraint.isNotNull((Object)resource, (String)"Trust certificates resource cannot be null");
    }

    public void setAuthenticationCertificate(@Nonnull @NotEmpty Resource resource) {
        this.authenticationCertificate = (Resource)Constraint.isNotNull((Object)resource, (String)"Authentication certificate resource cannot be null");
    }

    public void setAuthenticationKey(@Nonnull @NotEmpty Resource resource) {
        this.authenticationKey = (Resource)Constraint.isNotNull((Object)resource, (String)"Authentication key resource cannot be null");
    }

    public void setAuthenticationKeyPassword(@Nonnull @NotEmpty String password) {
        this.authenticationKeyPassword = (String)Constraint.isNotNull((Object)password, (String)"Authentication key password cannot be null");
    }

    @Nonnull
    public SSLContextInitializer createSSLContextInitializer() throws GeneralSecurityException {
        X509SSLContextInitializer sslInit = new X509SSLContextInitializer();
        try {
            if (this.trustCertificates != null) {
                sslInit.setTrustCertificates(X509Support.decodeCertificates((File)this.trustCertificates.getFile()).toArray(new X509Certificate[0]));
            }
            if (this.authenticationCertificate != null) {
                sslInit.setAuthenticationCertificate(X509Support.decodeCertificate((File)this.authenticationCertificate.getFile()));
            }
            if (this.authenticationKey != null) {
                sslInit.setAuthenticationKey(KeySupport.decodePrivateKey((File)this.authenticationKey.getFile(), this.authenticationKeyPassword != null ? this.authenticationKeyPassword.toCharArray() : null));
            }
        }
        catch (IOException e) {
            throw new GeneralSecurityException(e);
        }
        return sslInit;
    }
}

