/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.AbstractSubjectCanonicalizationAction;
import net.shibboleth.idp.authn.SubjectCanonicalizationFlowDescriptor;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class SelectSubjectCanonicalizationFlow
extends AbstractSubjectCanonicalizationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SelectSubjectCanonicalizationFlow.class);

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull SubjectCanonicalizationContext c14nContext) {
        SubjectCanonicalizationFlowDescriptor flow = c14nContext.getAttemptedFlow();
        if (flow != null) {
            this.log.info("{} Moving incomplete flow {} to intermediate set, reselecting a different one", (Object)this.getLogPrefix(), (Object)flow.getId());
            c14nContext.getIntermediateFlows().put(flow.ensureId(), c14nContext.getAttemptedFlow());
        }
        return super.doPreExecute(profileRequestContext, c14nContext);
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull SubjectCanonicalizationContext c14nContext) {
        SubjectCanonicalizationFlowDescriptor flow = this.selectUnattemptedFlow(profileRequestContext, c14nContext);
        if (flow == null) {
            this.log.error("{} No potential flows left to choose from, canonicalization will fail", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"NoPotentialFlow");
            return;
        }
        this.log.debug("{} Selecting canonicalization flow {}", (Object)this.getLogPrefix(), (Object)flow.ensureId());
        ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)flow.ensureId());
    }

    @Nullable
    private SubjectCanonicalizationFlowDescriptor selectUnattemptedFlow(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull SubjectCanonicalizationContext c14nContext) {
        for (SubjectCanonicalizationFlowDescriptor flow : c14nContext.getPotentialFlows().values()) {
            if (c14nContext.getIntermediateFlows().containsKey(flow.ensureId())) continue;
            this.log.debug("{} Checking canonicalization flow {} for applicability...", (Object)this.getLogPrefix(), (Object)flow.getId());
            c14nContext.setAttemptedFlow(flow);
            if (flow.test(profileRequestContext)) {
                return flow;
            }
            Exception ctxException = c14nContext.getException();
            this.log.debug("{} Canonicalization flow {} was not applicable: {}", new Object[]{this.getLogPrefix(), flow.getId(), ctxException != null ? ctxException.getMessage() : "reason unknown"});
            c14nContext.setException(null);
        }
        return null;
    }
}

