/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.authn.AbstractAuthenticationAction;
import net.shibboleth.idp.authn.config.AuthenticationProfileConfiguration;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.RequestedPrincipalContext;
import net.shibboleth.profile.config.ProfileConfiguration;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class InitializeRequestedPrincipalContext
extends AbstractAuthenticationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(InitializeRequestedPrincipalContext.class);
    private boolean replaceExistingContext;
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class);
    @NonnullBeforeExec
    private AuthenticationProfileConfiguration authenticationProfileConfig;

    public void setReplaceExistingContext(boolean flag) {
        this.checkSetterPreconditions();
        this.replaceExistingContext = flag;
    }

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        this.checkSetterPreconditions();
        this.relyingPartyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext lookup strategy cannot be null");
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        if (!super.doPreExecute(profileRequestContext, authenticationContext)) {
            return false;
        }
        RelyingPartyContext rpCtx = this.relyingPartyContextLookupStrategy.apply(profileRequestContext);
        if (rpCtx == null) {
            this.log.debug("{} No relying party context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRelyingPartyContext");
            return false;
        }
        ProfileConfiguration config = rpCtx.getProfileConfig();
        if (config == null) {
            this.log.debug("{} No profile configuration", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
            return false;
        }
        if (!(config instanceof AuthenticationProfileConfiguration)) {
            this.log.debug("{} Not an authentication profile", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
            return false;
        }
        this.authenticationProfileConfig = (AuthenticationProfileConfiguration)config;
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        List principals = this.authenticationProfileConfig.getDefaultAuthenticationMethods(profileRequestContext);
        if (principals.isEmpty()) {
            this.log.debug("{} Profile configuration did not supply any default authentication methods", (Object)this.getLogPrefix());
            return;
        }
        if (authenticationContext.getSubcontext(RequestedPrincipalContext.class) != null) {
            if (this.replaceExistingContext) {
                this.log.info("{} Replacing explicitly requested authentication criteria from relying party", (Object)this.getLogPrefix());
            } else {
                this.log.warn("{} Profile config overridden by explicitly requested authentication criteria, consider disallowing with disallowedFeatures property", (Object)this.getLogPrefix());
                return;
            }
        }
        RequestedPrincipalContext principalCtx = new RequestedPrincipalContext();
        principalCtx.setOperator("exact");
        principalCtx.setRequestedPrincipals(principals);
        principalCtx.setPrincipalEvalPredicateFactoryRegistry(authenticationContext.getPrincipalEvalPredicateFactoryRegistry());
        authenticationContext.addSubcontext((BaseContext)principalCtx, true);
        this.log.debug("{} Established RequestedPrincipalContext with {} methods", (Object)this.getLogPrefix(), (Object)principalCtx.getRequestedPrincipals().size());
    }
}

