/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.json.JsonReaderFactory;
import jakarta.json.JsonString;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonGeneratorFactory;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.Principal;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.principal.GenericPrincipalSerializer;
import net.shibboleth.idp.authn.principal.PrincipalSerializer;
import net.shibboleth.idp.authn.principal.PrincipalService;
import net.shibboleth.idp.authn.principal.PrincipalServiceManager;
import net.shibboleth.idp.authn.principal.impl.AuthenticationResultPrincipalSerializer;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.codec.Base64Support;
import net.shibboleth.shared.codec.EncodingException;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.security.x509.X509Support;
import org.opensaml.storage.StorageSerializer;
import org.slf4j.Logger;

public class DefaultAuthenticationResultSerializer
extends AbstractInitializableComponent
implements StorageSerializer<AuthenticationResult> {
    @Nonnull
    @NotEmpty
    private static final String FLOW_ID_FIELD = "id";
    @Nonnull
    @NotEmpty
    private static final String AUTHN_INSTANT_FIELD = "ts";
    @Nonnull
    @NotEmpty
    private static final String PRINCIPAL_ARRAY_FIELD = "princ";
    @Nonnull
    @NotEmpty
    private static final String PUB_CREDS_ARRAY_FIELD = "pub";
    @Nonnull
    @NotEmpty
    private static final String X509_CREDS_ARRAY_FIELD = "x509";
    @Nonnull
    @NotEmpty
    private static final String PRIV_CREDS_ARRAY_FIELD = "priv";
    @Nonnull
    @NotEmpty
    private static final String ADDTL_DATA_FIELD = "props";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DefaultAuthenticationResultSerializer.class);
    @Nonnull
    private final JsonGeneratorFactory generatorFactory = Json.createGeneratorFactory(null);
    @Nonnull
    private final JsonReaderFactory readerFactory = Json.createReaderFactory(null);
    @Nonnull
    private final PrincipalServiceManager principalServiceManager;
    @Nonnull
    private Collection<PrincipalSerializer<String>> principalSerializers = CollectionSupport.emptyList();
    @Nonnull
    private final AuthenticationResultPrincipalSerializer authnResultPrincipalSerializer = new AuthenticationResultPrincipalSerializer(this);
    @Nonnull
    private final GenericPrincipalSerializer genericSerializer;

    public DefaultAuthenticationResultSerializer() throws ComponentInitializationException {
        this.principalServiceManager = new PrincipalServiceManager(null);
        this.genericSerializer = new GenericPrincipalSerializer();
        this.genericSerializer.initialize();
    }

    public DefaultAuthenticationResultSerializer(@Nonnull PrincipalServiceManager manager, @Nonnull GenericPrincipalSerializer defaultSerializer) {
        this.principalServiceManager = (PrincipalServiceManager)Constraint.isNotNull((Object)manager, (String)"PrincipalServiceManager cannot be null");
        this.genericSerializer = (GenericPrincipalSerializer)Constraint.isNotNull((Object)defaultSerializer, (String)"Default serializer cannot be null");
    }

    @Nonnull
    public GenericPrincipalSerializer getGenericPrincipalSerializer() {
        return this.genericSerializer;
    }

    public void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        this.authnResultPrincipalSerializer.initialize();
        List serializers = this.principalServiceManager.all().stream().map(PrincipalService::getSerializer).collect(Collectors.toUnmodifiableList());
        if (serializers.isEmpty()) {
            this.principalSerializers = CollectionSupport.singletonList((Object)((Object)this.authnResultPrincipalSerializer));
        } else {
            ArrayList copy = new ArrayList(serializers);
            copy.add(this.authnResultPrincipalSerializer);
            this.principalSerializers = CollectionSupport.copyToList(copy);
        }
    }

    @Nonnull
    @NotEmpty
    public String serialize(@Nonnull AuthenticationResult instance) throws IOException {
        this.checkComponentActive();
        try {
            Set<X509Certificate> set;
            Set<Principal> set2;
            StringWriter sink = new StringWriter(128);
            JsonGenerator gen = this.generatorFactory.createGenerator((Writer)sink);
            gen.writeStartObject().write(FLOW_ID_FIELD, instance.getAuthenticationFlowId()).write(AUTHN_INSTANT_FIELD, instance.getAuthenticationInstant().toEpochMilli());
            Map addtlData = instance.getAdditionalData();
            if (!addtlData.isEmpty()) {
                gen.writeStartObject(ADDTL_DATA_FIELD);
                addtlData.forEach((k, v) -> gen.write(k, v));
                gen.writeEnd();
            }
            gen.writeStartArray(PRINCIPAL_ARRAY_FIELD);
            for (Principal principal : instance.getSubject().getPrincipals()) {
                assert (principal != null);
                this.serializePrincipal(gen, principal);
            }
            gen.writeEnd();
            Set<Principal> publicCreds = instance.getSubject().getPublicCredentials(Principal.class);
            if (publicCreds != null && !publicCreds.isEmpty()) {
                gen.writeStartArray(PUB_CREDS_ARRAY_FIELD);
                for (Principal principal : publicCreds) {
                    assert (principal != null);
                    this.serializePrincipal(gen, principal);
                }
                gen.writeEnd();
            }
            if ((set2 = instance.getSubject().getPrivateCredentials(Principal.class)) != null && !set2.isEmpty()) {
                gen.writeStartArray(PRIV_CREDS_ARRAY_FIELD);
                for (Principal p : set2) {
                    assert (p != null);
                    this.serializePrincipal(gen, p);
                }
                gen.writeEnd();
            }
            if ((set = instance.getSubject().getPublicCredentials(X509Certificate.class)) != null && !set.isEmpty()) {
                gen.writeStartArray(X509_CREDS_ARRAY_FIELD);
                for (X509Certificate x : set) {
                    try {
                        gen.write(Base64Support.encode((byte[])x.getEncoded(), (boolean)false));
                    }
                    catch (CertificateEncodingException | EncodingException e) {
                        this.log.warn("Unable to serialize X.509 certificate with subject: {}", (Object)x.getSubjectX500Principal().getName().toString());
                    }
                }
                gen.writeEnd();
            }
            gen.writeEnd().close();
            return sink.toString();
        }
        catch (JsonException e) {
            throw new IOException("Exception while serializing AuthenticationResult", e);
        }
    }

    @Nonnull
    public AuthenticationResult deserialize(long version, @Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Nonnull @NotEmpty String value, @Nullable Long expiration) throws IOException {
        AuthenticationResult authenticationResult;
        block24: {
            this.checkComponentActive();
            JsonReader reader = this.readerFactory.createReader((Reader)new StringReader(value));
            try {
                JsonArray x509Creds;
                JsonArray privateCreds;
                JsonArray publicCreds;
                JsonArray principals;
                JsonStructure st = reader.read();
                if (!(st instanceof JsonObject)) {
                    throw new IOException("Found invalid data structure while parsing AuthenticationResult");
                }
                JsonObject obj = (JsonObject)st;
                String flowId = obj.getString(FLOW_ID_FIELD);
                long authnInstant = obj.getJsonNumber(AUTHN_INSTANT_FIELD).longValueExact();
                AuthenticationResult result = new AuthenticationResult(flowId, new Subject());
                result.setAuthenticationInstant(Instant.ofEpochMilli(authnInstant));
                result.setLastActivityInstant(Instant.ofEpochMilli(expiration != null ? expiration : authnInstant));
                result.setPreviousResult(true);
                JsonObject addtlData = obj.getJsonObject(ADDTL_DATA_FIELD);
                if (addtlData != null) {
                    Map dataMap = result.getAdditionalData();
                    addtlData.entrySet().stream().filter(e -> ((JsonValue)e.getValue()).getValueType().equals((Object)JsonValue.ValueType.STRING)).forEach(e -> dataMap.put((String)e.getKey(), ((JsonString)e.getValue()).getString()));
                }
                if ((principals = obj.getJsonArray(PRINCIPAL_ARRAY_FIELD)) != null) {
                    for (Iterator val : principals) {
                        assert (val != null);
                        Principal principal = this.deserializePrincipal((JsonValue)val);
                        if (principal == null) continue;
                        result.getSubject().getPrincipals().add(principal);
                    }
                }
                if ((publicCreds = obj.getJsonArray(PUB_CREDS_ARRAY_FIELD)) != null) {
                    for (Iterator val : publicCreds) {
                        assert (val != null);
                        Principal principal = this.deserializePrincipal((JsonValue)val);
                        if (principal == null) continue;
                        result.getSubject().getPublicCredentials().add(principal);
                    }
                }
                if ((privateCreds = obj.getJsonArray(PRIV_CREDS_ARRAY_FIELD)) != null) {
                    for (JsonValue val : privateCreds) {
                        assert (val != null);
                        Principal principal = this.deserializePrincipal(val);
                        if (principal == null) continue;
                        result.getSubject().getPrivateCredentials().add(principal);
                    }
                }
                if ((x509Creds = obj.getJsonArray(X509_CREDS_ARRAY_FIELD)) != null) {
                    for (JsonValue val : x509Creds) {
                        if (val.getValueType() != JsonValue.ValueType.STRING) continue;
                        try {
                            String valStr = val.toString();
                            assert (valStr != null);
                            X509Certificate cert = X509Support.decodeCertificate((String)valStr);
                            result.getSubject().getPublicCredentials().add(cert);
                        }
                        catch (CertificateException e2) {
                            this.log.warn("Unable to parse certificate", (Throwable)e2);
                        }
                    }
                }
                authenticationResult = result;
                if (reader == null) break block24;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JsonException | ArithmeticException | ClassCastException | NullPointerException e3) {
                    throw new IOException("Found invalid data structure while parsing AuthenticationResult", e3);
                }
            }
            reader.close();
        }
        return authenticationResult;
    }

    private void serializePrincipal(@Nonnull JsonGenerator generator, @Nonnull Principal principal) throws IOException {
        PrincipalService principalService;
        String serializedForm = this.authnResultPrincipalSerializer.supports(principal) ? this.authnResultPrincipalSerializer.serialize(principal) : ((principalService = this.principalServiceManager.byClass(principal.getClass())) != null ? (String)principalService.getSerializer().serialize(principal) : (this.genericSerializer.supports(principal) ? this.genericSerializer.serialize(principal) : null));
        if (serializedForm != null) {
            try (JsonReader reader = this.readerFactory.createReader((Reader)new StringReader(serializedForm));){
                generator.write((JsonValue)reader.readObject());
            }
        }
    }

    @Nullable
    private Principal deserializePrincipal(@Nonnull JsonValue jsonValue) throws IOException {
        if (jsonValue instanceof JsonObject) {
            String json = ((JsonObject)jsonValue).toString();
            assert (json != null);
            for (PrincipalSerializer<String> serializer : this.principalSerializers) {
                if (!serializer.supports((Object)json)) continue;
                return serializer.deserialize((Object)json);
            }
            if (this.genericSerializer.supports(json)) {
                return this.genericSerializer.deserialize(json);
            }
        }
        return null;
    }
}

