/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.spring.velocity;

import jakarta.servlet.ServletContext;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.spring.velocity.VelocityConfig;
import net.shibboleth.shared.spring.velocity.VelocityEngineFactory;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.web.context.ServletContextAware;

public class VelocityConfigurer
extends VelocityEngineFactory
implements VelocityConfig,
InitializingBean,
ResourceLoaderAware,
ServletContextAware {
    @Nonnull
    @NotEmpty
    private static final String SPRING_MACRO_RESOURCE_LOADER_NAME = "springMacro";
    @Nonnull
    @NotEmpty
    private static final String SPRING_MACRO_RESOURCE_LOADER_CLASS = "resource.loader.springMacro.class";
    @Nonnull
    @NotEmpty
    private static final String SPRING_MACRO_LIBRARY = "net/shibboleth/shared/spring/velocity/spring.vm";
    @Nullable
    private ServletContext servletContext;
    @Nullable
    private VelocityEngine velocityEngine;

    public void setServletContext(@Nonnull ServletContext context) {
        this.servletContext = context;
    }

    public void afterPropertiesSet() throws IOException, VelocityException {
        if (this.velocityEngine == null) {
            this.velocityEngine = this.createVelocityEngine();
        }
    }

    @Override
    protected void postProcessVelocityEngine(@Nonnull VelocityEngine engine) {
        engine.setApplicationAttribute((Object)ServletContext.class.getName(), (Object)this.servletContext);
        engine.setProperty(SPRING_MACRO_RESOURCE_LOADER_CLASS, (Object)ClasspathResourceLoader.class.getName());
        engine.addProperty("resource.loaders", (Object)SPRING_MACRO_RESOURCE_LOADER_NAME);
        engine.addProperty("velocimacro.library.path", (Object)SPRING_MACRO_LIBRARY);
        this.velocityEngine = engine;
    }

    @Override
    @Nonnull
    public VelocityEngine getVelocityEngine() {
        if (this.velocityEngine != null) {
            return this.velocityEngine;
        }
        throw new IllegalStateException("Velocity engine not yet created");
    }
}

