/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.filter.context;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.filter.AttributeFilterException;
import net.shibboleth.idp.attribute.filter.context.AttributeFilterContext;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.messaging.context.BaseContext;

@NotThreadSafe
public final class AttributeFilterWorkContext
extends BaseContext {
    @Nonnull
    private final Map<String, Set<IdPAttributeValue>> permittedValues = new HashMap<String, Set<IdPAttributeValue>>();
    @Nonnull
    private final Map<String, Set<IdPAttributeValue>> deniedValues = new HashMap<String, Set<IdPAttributeValue>>();

    @Nonnull
    @Unmodifiable
    @NotLive
    public Map<String, Set<IdPAttributeValue>> getPermittedIdPAttributeValues() {
        return CollectionSupport.copyToMap(this.permittedValues);
    }

    public void addPermittedIdPAttributeValues(@Nonnull @NotEmpty String attributeId, @Nullable Collection<IdPAttributeValue> attributeValues) throws AttributeFilterException {
        BaseContext parent = this.getParent();
        if (!(parent instanceof AttributeFilterContext)) {
            throw new AttributeFilterException("AttributeFilterWorkContext was not a child of AttributeFilterContext");
        }
        Map<String, IdPAttribute> prefilteredAttributes = ((AttributeFilterContext)parent).getPrefilteredIdPAttributes();
        String trimmedAttributeId = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)attributeId), (String)"Attribute ID can not be null or empty");
        Constraint.isTrue((boolean)prefilteredAttributes.containsKey(trimmedAttributeId), (String)("no attribute with ID " + trimmedAttributeId + " exists in the pre-filtered attribute set"));
        if (attributeValues == null || attributeValues.isEmpty()) {
            return;
        }
        Set<IdPAttributeValue> permittedAttributeValues = this.permittedValues.get(trimmedAttributeId);
        if (permittedAttributeValues == null) {
            permittedAttributeValues = new LinkedHashSet<IdPAttributeValue>();
            this.permittedValues.put(trimmedAttributeId, permittedAttributeValues);
        }
        for (IdPAttributeValue value : attributeValues) {
            Constraint.isNotNull((Object)value, (String)"non null value cannot be added to permitted list");
            if (!prefilteredAttributes.get(trimmedAttributeId).getValues().contains(value)) {
                throw new AttributeFilterException("permitted value is not a current value of attribute " + trimmedAttributeId);
            }
            if (permittedAttributeValues.contains(value)) continue;
            permittedAttributeValues.add(value);
        }
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public Map<String, Set<IdPAttributeValue>> getDeniedAttributeValues() {
        return CollectionSupport.copyToMap(this.deniedValues);
    }

    public void addDeniedIdPAttributeValues(@Nonnull @NotEmpty String attributeId, @Nullable Collection<IdPAttributeValue> attributeValues) throws AttributeFilterException {
        BaseContext parent = this.getParent();
        if (!(parent instanceof AttributeFilterContext)) {
            throw new AttributeFilterException("AttributeFilterWorkContext was not a child of AttributeFilterContext");
        }
        Map<String, IdPAttribute> prefilteredAttributes = ((AttributeFilterContext)parent).getPrefilteredIdPAttributes();
        String trimmedAttributeId = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)attributeId), (String)"Attribute ID can not be null or empty");
        Constraint.isTrue((boolean)prefilteredAttributes.containsKey(trimmedAttributeId), (String)("No attribute with ID " + trimmedAttributeId + " exists in the pre-filtered attribute set"));
        if (attributeValues == null || attributeValues.isEmpty()) {
            return;
        }
        Set<IdPAttributeValue> deniedAttributeValues = this.deniedValues.get(trimmedAttributeId);
        if (deniedAttributeValues == null) {
            deniedAttributeValues = new LinkedHashSet<IdPAttributeValue>();
            this.deniedValues.put(trimmedAttributeId, deniedAttributeValues);
        }
        for (IdPAttributeValue value : attributeValues) {
            Constraint.isNotNull((Object)value, (String)"non null value cannot be added to denied list");
            if (!prefilteredAttributes.get(trimmedAttributeId).getValues().contains(value)) {
                throw new AttributeFilterException("denied value is not a current value of attribute " + trimmedAttributeId);
            }
            if (deniedAttributeValues.contains(value)) continue;
            deniedAttributeValues.add(value);
        }
    }
}

