/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.filter.context;

import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.filter.AttributeFilter;
import net.shibboleth.idp.attribute.filter.AttributeFilterException;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.NonnullSupplier;
import net.shibboleth.shared.service.ReloadableService;
import net.shibboleth.shared.service.ServiceException;
import net.shibboleth.shared.service.ServiceableComponent;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.navigate.ParentContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.ProxiedRequesterContext;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.slf4j.Logger;

@NotThreadSafe
public final class AttributeFilterContext
extends BaseContext {
    @Nonnull
    private Direction direction;
    @Nonnull
    private Function<AttributeFilterContext, ProfileRequestContext> profileRequestContextLookupStrategy;
    @Nonnull
    private Map<String, IdPAttribute> prefilteredAttributes = CollectionSupport.emptyMap();
    @Nonnull
    private Map<String, IdPAttribute> filteredAttributes = CollectionSupport.emptyMap();
    @Nullable
    private MetadataResolver metadataResolver;
    @Nullable
    private String principal;
    @Nullable
    private String attributeIssuerID;
    @Nullable
    private String attributeRecipientID;
    @Nullable
    private String attributeRecipientGroupID;
    @Nullable
    private SAMLMetadataContext issuerMetadataContext;
    @Nullable
    private SAMLMetadataContext requesterMetadataContext;
    @Nullable
    private ProxiedRequesterContext proxiedRequesterContext;
    @Nullable
    private SAMLMetadataContext proxiedRequesterMetadataContext;
    @Nullable
    private Function<AttributeFilterContext, SAMLMetadataContext> issuerMetadataContextLookupStrategy;
    @Nullable
    private Function<AttributeFilterContext, SAMLMetadataContext> requesterMetadataContextLookupStrategy;
    @Nullable
    private Function<AttributeFilterContext, ProxiedRequesterContext> proxiedRequesterContextLookupStrategy;
    @Nullable
    private Function<AttributeFilterContext, SAMLMetadataContext> proxiedRequesterMetadataContextLookupStrategy;

    public AttributeFilterContext() {
        this.direction = Direction.OUTBOUND;
        Function prcls = new ParentContextLookup(ProfileRequestContext.class).compose(afc -> afc.getParent());
        assert (prcls != null);
        this.profileRequestContextLookupStrategy = prcls;
    }

    @Nonnull
    public Direction getDirection() {
        return this.direction;
    }

    @Nonnull
    public AttributeFilterContext setDirection(@Nonnull Direction dir) {
        this.direction = (Direction)((Object)Constraint.isNotNull((Object)((Object)dir), (String)"Direction cannot be null"));
        return this;
    }

    @Nonnull
    public Function<AttributeFilterContext, ProfileRequestContext> getProfileRequestContextLookupStrategy() {
        return this.profileRequestContextLookupStrategy;
    }

    @Nonnull
    public AttributeFilterContext setProfileRequestContextLookupStrategy(@Nonnull Function<AttributeFilterContext, ProfileRequestContext> strategy) {
        this.profileRequestContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
        return this;
    }

    @Nonnull
    @NotLive
    @Unmodifiable
    public Map<String, IdPAttribute> getPrefilteredIdPAttributes() {
        return this.prefilteredAttributes;
    }

    @Nonnull
    public AttributeFilterContext setPrefilteredIdPAttributes(@Nullable Collection<IdPAttribute> attributes) {
        this.prefilteredAttributes = attributes != null ? (Map)((NonnullSupplier)attributes.stream().collect(CollectionSupport.nonnullCollector(Collectors.toUnmodifiableMap(IdPAttribute::getId, e -> e, CollectionSupport.warningMergeFunction((String)"AttrtibuteFilterContextPrefiltered", (boolean)true))))).get() : CollectionSupport.emptyMap();
        return this;
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public Map<String, IdPAttribute> getFilteredIdPAttributes() {
        return this.filteredAttributes;
    }

    @Nonnull
    public AttributeFilterContext setFilteredIdPAttributes(@Nullable Collection<IdPAttribute> attributes) {
        this.filteredAttributes = attributes != null ? (Map)((NonnullSupplier)attributes.stream().collect(CollectionSupport.nonnullCollector(Collectors.toUnmodifiableMap(IdPAttribute::getId, e -> e, CollectionSupport.warningMergeFunction((String)"AttrtibuteFilterContextFiltered", (boolean)true))))).get() : CollectionSupport.emptyMap();
        return this;
    }

    @Nullable
    public MetadataResolver getMetadataResolver() {
        return this.metadataResolver;
    }

    @Nonnull
    public AttributeFilterContext setMetadataResolver(@Nullable MetadataResolver resolver) {
        this.metadataResolver = resolver;
        return this;
    }

    @Nullable
    public String getPrincipal() {
        return this.principal;
    }

    @Nonnull
    public AttributeFilterContext setPrincipal(@Nullable String who) {
        this.principal = who;
        return this;
    }

    @Nullable
    public String getAttributeIssuerID() {
        return this.attributeIssuerID;
    }

    @Nonnull
    public AttributeFilterContext setAttributeIssuerID(@Nullable String value) {
        this.attributeIssuerID = value;
        return this;
    }

    @Nullable
    public String getAttributeRecipientID() {
        return this.attributeRecipientID;
    }

    @Nonnull
    public AttributeFilterContext setAttributeRecipientID(@Nullable String value) {
        this.attributeRecipientID = value;
        return this;
    }

    @Nullable
    public String getAttributeRecipientGroupID() {
        return this.attributeRecipientGroupID;
    }

    @Nonnull
    public AttributeFilterContext setAttributeRecipientGroupID(@Nullable String value) {
        this.attributeRecipientGroupID = value;
        return this;
    }

    @Nullable
    public Function<AttributeFilterContext, SAMLMetadataContext> getRequesterMetadataContextLookupStrategy() {
        return this.requesterMetadataContextLookupStrategy;
    }

    @Nonnull
    public AttributeFilterContext setRequesterMetadataContextLookupStrategy(@Nullable Function<AttributeFilterContext, SAMLMetadataContext> strategy) {
        this.requesterMetadataContextLookupStrategy = strategy;
        return this;
    }

    @Nonnull
    public AttributeFilterContext setIssuerMetadataContextLookupStrategy(@Nullable Function<AttributeFilterContext, SAMLMetadataContext> strategy) {
        this.issuerMetadataContextLookupStrategy = strategy;
        return this;
    }

    @Nullable
    public Function<AttributeFilterContext, SAMLMetadataContext> getIssuerMetadataContextLookupStrategy() {
        return this.issuerMetadataContextLookupStrategy;
    }

    @Nullable
    public Function<AttributeFilterContext, ProxiedRequesterContext> getProxiedRequesterContextLookupStrategy() {
        return this.proxiedRequesterContextLookupStrategy;
    }

    @Nonnull
    public AttributeFilterContext setProxiedRequesterContextLookupStrategy(@Nullable Function<AttributeFilterContext, ProxiedRequesterContext> strategy) {
        this.proxiedRequesterContextLookupStrategy = strategy;
        return this;
    }

    @Nullable
    public Function<AttributeFilterContext, SAMLMetadataContext> getProxiedRequesterMetadataContextLookupStrategy() {
        return this.proxiedRequesterMetadataContextLookupStrategy;
    }

    @Nonnull
    public AttributeFilterContext setProxiedRequesterMetadataContextLookupStrategy(@Nullable Function<AttributeFilterContext, SAMLMetadataContext> strategy) {
        this.proxiedRequesterMetadataContextLookupStrategy = strategy;
        return this;
    }

    @Nullable
    public SAMLMetadataContext getIssuerMetadataContext() {
        if (null == this.issuerMetadataContext && null != this.issuerMetadataContextLookupStrategy) {
            this.issuerMetadataContext = this.issuerMetadataContextLookupStrategy.apply(this);
        }
        return this.issuerMetadataContext;
    }

    @Nullable
    public SAMLMetadataContext getRequesterMetadataContext() {
        if (null == this.requesterMetadataContext && null != this.requesterMetadataContextLookupStrategy) {
            this.requesterMetadataContext = this.requesterMetadataContextLookupStrategy.apply(this);
        }
        return this.requesterMetadataContext;
    }

    @Nullable
    public ProxiedRequesterContext getProxiedRequesterContext() {
        if (null == this.proxiedRequesterContext && null != this.proxiedRequesterContextLookupStrategy) {
            this.proxiedRequesterContext = this.proxiedRequesterContextLookupStrategy.apply(this);
        }
        return this.proxiedRequesterContext;
    }

    @Nullable
    public SAMLMetadataContext getProxiedRequesterMetadataContext() {
        if (null == this.proxiedRequesterMetadataContext && null != this.proxiedRequesterMetadataContextLookupStrategy) {
            this.proxiedRequesterMetadataContext = this.proxiedRequesterMetadataContextLookupStrategy.apply(this);
        }
        return this.proxiedRequesterMetadataContext;
    }

    public void filterAttributes(@Nonnull ReloadableService<AttributeFilter> attributeFilterService) {
        Logger log = LoggerFactory.getLogger(AttributeFilterContext.class);
        try (ServiceableComponent component = attributeFilterService.getServiceableComponent();){
            ((AttributeFilter)component.getComponent()).filterAttributes(this);
        }
        catch (AttributeFilterException e) {
            log.error("Error filtering attributes", (Throwable)((Object)e));
        }
        catch (ServiceException e) {
            log.error("Invalid AttributeFilter configuration", (Throwable)e);
        }
    }

    public static enum Direction {
        INBOUND,
        OUTBOUND;

    }
}

