/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.filter;

import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.filter.BaseBridgingClass;
import net.shibboleth.idp.attribute.filter.Matcher;
import net.shibboleth.idp.attribute.filter.PolicyRequirementRule;
import net.shibboleth.idp.attribute.filter.context.AttributeFilterContext;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.DestructableComponent;
import net.shibboleth.shared.component.IdentifiedComponent;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

public final class MatcherFromPolicy
extends BaseBridgingClass
implements Matcher,
IdentifiedComponent,
DestructableComponent {
    @Nonnull
    private final PolicyRequirementRule rule;
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(MatcherFromPolicy.class);

    public MatcherFromPolicy(@Nonnull @ParameterName(name="theRule") PolicyRequirementRule theRule) {
        super(theRule);
        this.rule = theRule;
    }

    @Nonnull
    public PolicyRequirementRule getPolicyRequirementRule() {
        return this.rule;
    }

    @Override
    @Nullable
    public Set<IdPAttributeValue> getMatchingValues(@Nonnull IdPAttribute attribute, @Nonnull AttributeFilterContext filterContext) {
        PolicyRequirementRule.Tristate result = this.rule.matches(filterContext);
        if (PolicyRequirementRule.Tristate.FAIL == result) {
            this.log.warn("{} The rule returned FAIL, returning null", (Object)this.getLogPrefix());
            return null;
        }
        if (PolicyRequirementRule.Tristate.FALSE == result) {
            this.log.debug("{} The rule returned FALSE, no values returned", (Object)this.getLogPrefix());
            return CollectionSupport.emptySet();
        }
        this.log.debug("{} The rule returned TRUE, all values returned", (Object)this.getLogPrefix());
        return Set.copyOf(attribute.getValues());
    }
}

