/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.props;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ldaptive.props.PropertyInvoker;
import org.ldaptive.props.PropertyValueParser;

public abstract class AbstractPropertyInvoker
implements PropertyInvoker {
    private static final Map<String, Map<String, Method[]>> PROPERTIES_CACHE = new HashMap<String, Map<String, Method[]>>();
    private Class<?> clazz;
    private Map<String, Method[]> properties;

    protected synchronized void initialize(Class<?> c) {
        String cacheKey = c.getName();
        if (PROPERTIES_CACHE.containsKey(cacheKey)) {
            this.properties = PROPERTIES_CACHE.get(cacheKey);
        } else {
            Method[] m;
            String pName;
            String mName;
            this.properties = new HashMap<String, Method[]>();
            for (Method method2 : c.getMethods()) {
                if (method2.isBridge()) continue;
                if (method2.getName().startsWith("get") && method2.getParameterTypes().length == 0) {
                    mName = method2.getName().substring(3);
                    pName = Character.toLowerCase(mName.charAt(0)) + mName.substring(1);
                    if (this.properties.containsKey(pName)) {
                        m = this.properties.get(pName);
                        m[0] = method2;
                        continue;
                    }
                    this.properties.put(pName, new Method[]{method2, null});
                    continue;
                }
                if (method2.getName().startsWith("is") && method2.getParameterTypes().length == 0) {
                    mName = method2.getName().substring(2);
                    pName = Character.toLowerCase(mName.charAt(0)) + mName.substring(1);
                    if (this.properties.containsKey(pName)) {
                        m = this.properties.get(pName);
                        if (m[0] != null) continue;
                        m[0] = method2;
                        continue;
                    }
                    this.properties.put(pName, new Method[]{method2, null});
                    continue;
                }
                if (!"initialize".equals(method2.getName()) || method2.getParameterTypes().length != 0) continue;
                String pName2 = method2.getName();
                this.properties.put(pName2, new Method[]{method2, method2});
            }
            for (Method method2 : c.getMethods()) {
                if (method2.isBridge() || !method2.getName().startsWith("set") || method2.getParameterTypes().length != 1 || !this.properties.containsKey(pName = Character.toLowerCase((mName = method2.getName().substring(3)).charAt(0)) + mName.substring(1)) || (m = this.properties.get(pName))[0] == null || !method2.getParameterTypes()[0].equals(m[0].getReturnType())) continue;
                m[1] = method2;
            }
            this.properties.values().removeIf(method -> method[0] == null || method[1] == null);
            PROPERTIES_CACHE.put(cacheKey, Collections.unmodifiableMap(this.properties));
        }
        this.clazz = c;
    }

    @Override
    public void setProperty(Object object, String name, String value) {
        Method setter;
        Method getter;
        if (!this.clazz.isInstance(object)) {
            throw new IllegalArgumentException("Illegal attempt to set property for class " + this.clazz.getName() + " on object of type " + object.getClass().getName());
        }
        Method method = getter = this.properties.get(name) != null ? this.properties.get(name)[0] : null;
        if (getter == null) {
            throw new IllegalArgumentException("No getter method found for " + name + " on object " + this.clazz.getName());
        }
        Method method2 = setter = this.properties.get(name) != null ? this.properties.get(name)[1] : null;
        if (setter == null) {
            throw new IllegalArgumentException("No setter method found for " + name + " on object " + this.clazz.getName());
        }
        AbstractPropertyInvoker.invokeMethod(setter, object, this.convertValue(getter.getReturnType(), value));
    }

    protected abstract Object convertValue(Class<?> var1, String var2);

    @Override
    public boolean hasProperty(String name) {
        return this.properties.containsKey(name);
    }

    @Override
    public Set<String> getProperties() {
        return Collections.unmodifiableSet(this.properties.keySet());
    }

    public static <T> T instantiateType(T type, String className) {
        try {
            try {
                Class<?> clazz = AbstractPropertyInvoker.createClass(className);
                Constructor<?> con = clazz.getDeclaredConstructor(null);
                Object t = con.newInstance(new Object[0]);
                return (T)t;
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalArgumentException(e);
            }
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("Error instantiating type " + type + " using  " + className, e);
        }
    }

    public static Class<?> createClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(String.format("Could not find class '%s'", className), e);
        }
    }

    protected Object convertSimpleType(Class<?> type, String value) {
        Object newValue = value;
        if (Class.class.isAssignableFrom(type)) {
            newValue = this.createTypeFromPropertyValue(Class.class, value);
        } else if (Class[].class.isAssignableFrom(type)) {
            newValue = this.createArrayTypeFromPropertyValue(Class.class, value);
        } else if (type.isEnum()) {
            newValue = AbstractPropertyInvoker.getEnum(type, value);
        } else if (type.isArray() && type.getComponentType().isEnum()) {
            newValue = this.createArrayEnumFromPropertyValue(type.getComponentType(), value);
        } else if (String[].class == type) {
            newValue = value.split(",");
        } else if (Object[].class == type) {
            newValue = value.split(",");
        } else if (Map.class == type) {
            newValue = Stream.of(value.split(",")).map(s -> s.split("=")).collect(Collectors.toMap(v -> v[0], v -> v[1]));
        } else if (Float.TYPE == type || Float.class == type) {
            newValue = Float.valueOf(Float.parseFloat(value));
        } else if (Integer.TYPE == type || Integer.class == type) {
            newValue = Integer.parseInt(value);
        } else if (Long.TYPE == type || Long.class == type) {
            newValue = Long.parseLong(value);
        } else if (Short.TYPE == type || Short.class == type) {
            newValue = Short.parseShort(value);
        } else if (Double.TYPE == type || Double.class == type) {
            newValue = Double.parseDouble(value);
        } else if (Boolean.TYPE == type || Boolean.class == type) {
            newValue = Boolean.valueOf(value);
        } else if (Duration.class == type) {
            newValue = Duration.parse(value);
        }
        return newValue;
    }

    protected static Enum<?> getEnum(Class<?> clazz, String value) {
        for (Object o : clazz.getEnumConstants()) {
            Enum e = (Enum)o;
            if (!e.name().equals(value)) continue;
            return e;
        }
        throw new IllegalArgumentException(String.format("Unknown enum value %s for %s", value, clazz));
    }

    protected Object createTypeFromPropertyValue(Class<?> c, String s) {
        Class<?> newObject;
        if ("null".equals(s)) {
            newObject = null;
        } else if (PropertyValueParser.isConfig(s)) {
            PropertyValueParser configParser = new PropertyValueParser(s);
            newObject = configParser.initializeType();
        } else {
            newObject = Class.class == c ? AbstractPropertyInvoker.createClass(s) : AbstractPropertyInvoker.instantiateType(c, s);
        }
        return newObject;
    }

    protected Object createArrayTypeFromPropertyValue(Class<?> c, String s) {
        Object newObject;
        if ("null".equals(s)) {
            newObject = null;
        } else if (s.contains("},")) {
            String[] classes = s.split("\\},");
            newObject = Array.newInstance(c, classes.length);
            for (int i = 0; i < classes.length; ++i) {
                classes[i] = classes[i] + "}";
                if (!PropertyValueParser.isConfig(classes[i])) {
                    throw new IllegalArgumentException(String.format("Could not parse property string: %s", classes[i]));
                }
                PropertyValueParser configParser = new PropertyValueParser(classes[i]);
                Array.set(newObject, i, configParser.initializeType());
            }
        } else {
            String[] classes = s.split(",");
            newObject = Array.newInstance(c, classes.length);
            for (int i = 0; i < classes.length; ++i) {
                if (PropertyValueParser.isConfig(classes[i])) {
                    PropertyValueParser configParser = new PropertyValueParser(classes[i]);
                    Array.set(newObject, i, configParser.initializeType());
                    continue;
                }
                if (Class.class == c) {
                    Array.set(newObject, i, AbstractPropertyInvoker.createClass(classes[i]));
                    continue;
                }
                Array.set(newObject, i, AbstractPropertyInvoker.instantiateType(c, classes[i]));
            }
        }
        return newObject;
    }

    protected Object createArrayEnumFromPropertyValue(Class<?> c, String s) {
        Object newObject;
        if ("null".equals(s)) {
            newObject = null;
        } else {
            String[] values = s.split(",");
            newObject = Array.newInstance(c, values.length);
            for (int i = 0; i < values.length; ++i) {
                Array.set(newObject, i, AbstractPropertyInvoker.getEnum(c, values[i]));
            }
        }
        return newObject;
    }

    public static Object invokeMethod(Method method, Object object, Object arg) {
        try {
            try {
                Object[] params = new Object[]{arg};
                if (arg == null && method.getParameterTypes().length == 0) {
                    params = null;
                }
                return method.invoke(object, params);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalArgumentException(e);
            }
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("Error invoking " + method + " on " + object + " with param " + arg, e);
        }
    }
}

