/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.pool;

import java.time.Duration;
import org.ldaptive.pool.PruneStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPruneStrategy
implements PruneStrategy {
    protected static final Duration DEFAULT_PRUNE_PERIOD = Duration.ofMinutes(5L);
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Duration prunePeriod;

    @Override
    public Duration getPrunePeriod() {
        return this.prunePeriod;
    }

    public void setPrunePeriod(Duration period) {
        if (period == null || period.isNegative() || period.isZero()) {
            throw new IllegalArgumentException("Prune period cannot be null, negative or zero");
        }
        this.prunePeriod = period;
    }

    protected static abstract class AbstractBuilder<B, T extends AbstractPruneStrategy> {
        protected final T object;

        protected AbstractBuilder(T t) {
            this.object = t;
        }

        protected abstract B self();

        public B period(Duration period) {
            ((AbstractPruneStrategy)this.object).setPrunePeriod(period);
            return this.self();
        }

        public T build() {
            return this.object;
        }
    }
}

