/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.filter;

import org.ldaptive.ResultCode;
import org.ldaptive.filter.AndFilter;
import org.ldaptive.filter.Filter;
import org.ldaptive.filter.FilterFunction;
import org.ldaptive.filter.FilterParseException;
import org.ldaptive.filter.FilterSet;
import org.ldaptive.filter.NotFilter;
import org.ldaptive.filter.OrFilter;

public abstract class AbstractFilterFunction
implements FilterFunction {
    private static final int MAX_FILTER_DEPTH = 100;

    @Override
    public Filter parse(String filter) throws FilterParseException {
        String balancedFilter;
        if (filter.startsWith("(")) {
            if (!filter.endsWith(")")) {
                throw new FilterParseException(ResultCode.FILTER_ERROR, "Unbalanced parentheses. Opening paren without closing paren.");
            }
            balancedFilter = filter;
        } else {
            if (filter.endsWith(")")) {
                throw new FilterParseException(ResultCode.FILTER_ERROR, "Unbalanced parentheses. Closing paren without opening paren.");
            }
            balancedFilter = "(".concat(filter).concat(")");
        }
        try {
            return this.readNextComponent(balancedFilter, 0);
        }
        catch (FilterParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FilterParseException(ResultCode.FILTER_ERROR, (Throwable)e);
        }
    }

    private Filter readNextComponent(String filter, int depth) throws FilterParseException {
        Filter searchFilter;
        if (depth > 100) {
            throw new FilterParseException(ResultCode.FILTER_ERROR, "Filter parse depth exceeded");
        }
        int end = filter.length() - 1;
        if (filter.charAt(0) != '(' || filter.charAt(end) != ')') {
            throw new FilterParseException(ResultCode.FILTER_ERROR, "Filter must be surround by parentheses: '" + filter + "'");
        }
        int pos = 1;
        switch (filter.charAt(pos)) {
            case '&': {
                searchFilter = this.readFilterSet(new AndFilter(), filter, ++pos, end, depth);
                break;
            }
            case '|': {
                searchFilter = this.readFilterSet(new OrFilter(), filter, ++pos, end, depth);
                break;
            }
            case '!': {
                searchFilter = this.readFilterSet(new NotFilter(), filter, ++pos, end, depth);
                break;
            }
            default: {
                searchFilter = this.parseFilterComp(filter);
                if (searchFilter != null) break;
                throw new FilterParseException(ResultCode.FILTER_ERROR, "Could not determine filter type for '" + filter + "'");
            }
        }
        return searchFilter;
    }

    private FilterSet readFilterSet(FilterSet set, String filter, int start, int end, int depth) throws FilterParseException {
        int pos = start;
        int closeIndex = this.findMatchingParenPosition(filter, pos);
        if (filter.charAt(pos) != '(' || closeIndex == -1 || closeIndex == end) {
            throw new FilterParseException(ResultCode.FILTER_ERROR, "Invalid filter syntax, missing parenthesis after " + set.getType());
        }
        while (pos < end) {
            set.add(this.readNextComponent(filter.substring(pos, closeIndex + 1), depth + 1));
            pos = closeIndex + 1;
            if (pos >= end) continue;
            closeIndex = this.findMatchingParenPosition(filter, pos);
        }
        if (pos > end) {
            throw new FilterParseException(ResultCode.FILTER_ERROR, "Invalid filter syntax, missing parenthesis after " + set.getType());
        }
        return set;
    }

    private int findMatchingParenPosition(String filter, int start) throws FilterParseException {
        if (filter == null || filter.length() == 0) {
            throw new FilterParseException(ResultCode.FILTER_ERROR, "Filter cannot be null or empty");
        }
        if (filter.charAt(start) != '(') {
            throw new FilterParseException(ResultCode.FILTER_ERROR, "Filter must begin with '('");
        }
        int parenCount = 1;
        for (int pos = start + 1; pos < filter.length(); ++pos) {
            char c = filter.charAt(pos);
            if (c == '(') {
                ++parenCount;
            } else if (c == ')') {
                --parenCount;
            }
            if (parenCount != 0) continue;
            return pos;
        }
        return -1;
    }

    protected abstract Filter parseFilterComp(String var1) throws FilterParseException;
}

