/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.ext;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.ldaptive.AddOperation;
import org.ldaptive.AddRequest;
import org.ldaptive.AddResponse;
import org.ldaptive.AttributeModification;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.DeleteOperation;
import org.ldaptive.DeleteRequest;
import org.ldaptive.DeleteResponse;
import org.ldaptive.LdapEntry;
import org.ldaptive.LdapException;
import org.ldaptive.ModifyOperation;
import org.ldaptive.ModifyRequest;
import org.ldaptive.ModifyResponse;
import org.ldaptive.Result;
import org.ldaptive.ResultCode;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResponse;
import org.ldaptive.ext.MergeRequest;
import org.ldaptive.handler.ResultPredicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeOperation {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ConnectionFactory connectionFactory;
    private SearchOperation searchOperation;
    private AddOperation addOperation;
    private ModifyOperation modifyOperation;
    private DeleteOperation deleteOperation;
    private ResultPredicate throwCondition;

    public MergeOperation() {
    }

    public MergeOperation(ConnectionFactory factory) {
        this.connectionFactory = factory;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory factory) {
        this.connectionFactory = factory;
    }

    public SearchOperation getSearchOperation() {
        return this.searchOperation;
    }

    public void setSearchOperation(SearchOperation operation) {
        this.searchOperation = operation;
    }

    public AddOperation getAddOperation() {
        return this.addOperation;
    }

    public void setAddOperation(AddOperation operation) {
        this.addOperation = operation;
    }

    public ModifyOperation getModifyOperation() {
        return this.modifyOperation;
    }

    public void setModifyOperation(ModifyOperation operation) {
        this.modifyOperation = operation;
    }

    public DeleteOperation getDeleteOperation() {
        return this.deleteOperation;
    }

    public void setDeleteOperation(DeleteOperation operation) {
        this.deleteOperation = operation;
    }

    public ResultPredicate getThrowCondition() {
        return this.throwCondition;
    }

    public void setThrowCondition(ResultPredicate function) {
        this.throwCondition = function;
    }

    public Result execute(MergeRequest request) throws LdapException {
        Result result;
        LdapEntry sourceEntry = request.getEntry();
        SearchOperation operation = this.searchOperation != null ? SearchOperation.copy(this.searchOperation) : new SearchOperation();
        operation.setConnectionFactory(this.connectionFactory);
        operation.setThrowCondition(r -> r.getResultCode() != ResultCode.SUCCESS && r.getResultCode() != ResultCode.NO_SUCH_OBJECT);
        SearchResponse searchResult = operation.execute(SearchRequest.objectScopeSearchRequest(sourceEntry.getDn(), request.getSearchAttributes()));
        if (searchResult.entrySize() == 0) {
            if (request.getDeleteEntry()) {
                this.logger.info("Target entry does not exist, no delete performed for request {}", (Object)request);
                result = null;
            } else {
                result = this.add(request, sourceEntry);
                if (this.throwCondition != null) {
                    this.throwCondition.testAndThrow(result);
                }
            }
        } else if (request.getDeleteEntry()) {
            result = this.delete(request, sourceEntry);
            if (this.throwCondition != null) {
                this.throwCondition.testAndThrow(result);
            }
        } else {
            result = this.modify(request, sourceEntry, searchResult.getEntry());
            if (this.throwCondition != null) {
                this.throwCondition.testAndThrow(result);
            }
        }
        return result;
    }

    protected Result modify(MergeRequest request, LdapEntry source, LdapEntry target) throws LdapException {
        AttributeModification[] modifications = LdapEntry.computeModifications(source, target, request.isUseReplace());
        if (modifications != null && modifications.length > 0) {
            List<String> l;
            ArrayList resultModifications = new ArrayList(1);
            resultModifications.add(new ArrayList(modifications.length));
            String[] includeAttrs = request.getIncludeAttributes();
            String[] excludeAttrs = request.getExcludeAttributes();
            if (includeAttrs != null && includeAttrs.length > 0) {
                l = Arrays.asList(includeAttrs);
                for (AttributeModification am : modifications) {
                    if (!l.contains(am.getAttribute().getName())) continue;
                    ((List)resultModifications.get(0)).add(am);
                }
            } else if (excludeAttrs != null && excludeAttrs.length > 0) {
                l = Arrays.asList(excludeAttrs);
                for (AttributeModification am : modifications) {
                    if (l.contains(am.getAttribute().getName())) continue;
                    ((List)resultModifications.get(0)).add(am);
                }
            } else {
                Collections.addAll((Collection)resultModifications.get(0), modifications);
            }
            if (!((List)resultModifications.get(0)).isEmpty()) {
                List processedModifications = resultModifications;
                if (request.getAttributeModificationsHandlers() != null) {
                    for (MergeRequest.AttributeModificationsHandler processor : request.getAttributeModificationsHandlers()) {
                        processedModifications = (List)processor.apply(processedModifications);
                    }
                }
                this.logger.debug("Modifying target entry {} with modifications {} from source entry {} for request {}", new Object[]{target, processedModifications, source, request});
                ModifyResponse result = null;
                for (List batch : processedModifications) {
                    ModifyOperation operation = this.modifyOperation != null ? ModifyOperation.copy(this.modifyOperation) : new ModifyOperation();
                    operation.setConnectionFactory(this.connectionFactory);
                    result = operation.execute((ModifyRequest)ModifyRequest.builder().dn(target.getDn()).modifications((AttributeModification[])batch.toArray(AttributeModification[]::new)).build());
                }
                this.logger.info("Modified target entry {} with modifications {} from source entry {} for request {}", new Object[]{target, processedModifications, source, request});
                return result;
            }
        }
        this.logger.info("Target entry {} equals source entry {}, no modification performed for request {}", new Object[]{target, source, request});
        return null;
    }

    protected Result add(MergeRequest request, LdapEntry entry) throws LdapException {
        AddOperation operation = this.addOperation != null ? AddOperation.copy(this.addOperation) : new AddOperation();
        operation.setConnectionFactory(this.connectionFactory);
        AddResponse result = operation.execute((AddRequest)AddRequest.builder().dn(entry.getDn()).attributes(entry.getAttributes()).build());
        this.logger.info("Added entry {} for request {}", (Object)entry, (Object)request);
        return result;
    }

    protected Result delete(MergeRequest request, LdapEntry entry) throws LdapException {
        DeleteOperation operation = this.deleteOperation != null ? DeleteOperation.copy(this.deleteOperation) : new DeleteOperation();
        operation.setConnectionFactory(this.connectionFactory);
        DeleteResponse result = operation.execute(new DeleteRequest(entry.getDn()));
        this.logger.info("Delete entry {} for request {}", (Object)entry, (Object)request);
        return result;
    }
}

