/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.dn;

import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.ldaptive.LdapUtils;
import org.ldaptive.dn.AttributeValueEscaper;
import org.ldaptive.dn.DefaultAttributeValueEscaper;
import org.ldaptive.dn.NameValue;
import org.ldaptive.dn.RDn;
import org.ldaptive.dn.RDnNormalizer;

public class DefaultRDnNormalizer
implements RDnNormalizer {
    public static final Function<String, String> LOWERCASE = new Function<String, String>(){

        @Override
        public String apply(String s) {
            return LdapUtils.toLowerCase(s);
        }

        public String toString() {
            return "LOWERCASE";
        }
    };
    public static final Function<String, String> COMPRESS = new Function<String, String>(){

        @Override
        public String apply(String s) {
            return LdapUtils.compressSpace(s, false);
        }

        public String toString() {
            return "COMPRESS";
        }
    };
    public static final Function<String, String> LOWERCASE_COMPRESS = new Function<String, String>(){

        @Override
        public String apply(String s) {
            return LdapUtils.toLowerCase(LdapUtils.compressSpace(s, false));
        }

        public String toString() {
            return "LOWERCASE_COMPRESS";
        }
    };
    private final Function<String, String> attributeNameFunction;
    private final Function<String, String> attributeValueFunction;
    private final AttributeValueEscaper attributeValueEscaper;

    public DefaultRDnNormalizer() {
        this(new DefaultAttributeValueEscaper(), LOWERCASE, LOWERCASE_COMPRESS);
    }

    public DefaultRDnNormalizer(AttributeValueEscaper escaper) {
        this(escaper, LOWERCASE, LOWERCASE_COMPRESS);
    }

    public DefaultRDnNormalizer(AttributeValueEscaper escaper, Function<String, String> nameNormalizer, Function<String, String> valueNormalizer) {
        this.attributeValueEscaper = escaper;
        this.attributeNameFunction = nameNormalizer;
        this.attributeValueFunction = valueNormalizer;
    }

    public AttributeValueEscaper getValueEscaper() {
        return this.attributeValueEscaper;
    }

    public Function<String, String> getNameFunction() {
        return this.attributeNameFunction;
    }

    public Function<String, String> getValueFunction() {
        return this.attributeValueFunction;
    }

    @Override
    public RDn normalize(RDn rdn) {
        Set nameValues = rdn.getNameValues().stream().map(nv -> new NameValue(this.attributeNameFunction.apply(nv.getName()), this.attributeValueEscaper.escape(this.attributeValueFunction.apply(nv.getStringValue())))).sorted(Comparator.comparing(NameValue::getName)).collect(Collectors.toCollection(LinkedHashSet::new));
        return new RDn(nameValues);
    }

    public String toString() {
        return this.getClass().getName() + "@" + this.hashCode() + "::attributeNameFunction=" + this.attributeNameFunction + ", attributeValueFunction=" + this.attributeValueFunction + ", attributeValueEscaper=" + this.attributeValueEscaper;
    }
}

