/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.control.util;

import java.time.Duration;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.ldaptive.AbstractConnectionValidator;
import org.ldaptive.ConnectionConfig;
import org.ldaptive.ConnectionValidator;
import org.ldaptive.LdapEntry;
import org.ldaptive.LdapException;
import org.ldaptive.Result;
import org.ldaptive.SearchConnectionValidator;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResultReference;
import org.ldaptive.SingleConnectionFactory;
import org.ldaptive.control.util.CookieManager;
import org.ldaptive.control.util.SyncReplClient;
import org.ldaptive.extended.SyncInfoMessage;
import org.ldaptive.transport.Transport;
import org.ldaptive.transport.netty.ConnectionFactoryTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncReplRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncReplRunner.class);
    private static final int IO_WORKER_THREADS = 1;
    private static final int MESSAGE_WORKER_THREADS = 4;
    private final SearchRequest searchRequest;
    private final CookieManager cookieManager;
    private SyncReplClient syncReplClient;
    private Supplier<Boolean> onStart;
    private Consumer<LdapEntry> onEntry;
    private Consumer<SearchResultReference> onReference;
    private Consumer<Result> onResult;
    private Consumer<SyncInfoMessage> onMessage;
    private Consumer<Exception> onException;
    private boolean started;

    public SyncReplRunner(SingleConnectionFactory cf, SearchRequest request, CookieManager manager) {
        this.syncReplClient = new SyncReplClient(cf, true);
        this.searchRequest = request;
        this.cookieManager = manager;
        cf.setOnOpen(conn -> {
            try {
                this.syncReplClient.send(this.searchRequest, this.cookieManager);
            }
            catch (LdapException e) {
                LOGGER.error("Could not send sync repl request", (Throwable)e);
                return false;
            }
            return true;
        });
        cf.setOnClose(conn -> {
            try {
                if (!this.syncReplClient.isComplete()) {
                    this.syncReplClient.cancel();
                }
            }
            catch (Exception e) {
                LOGGER.warn("Could not cancel sync repl request", (Throwable)e);
                return false;
            }
            return true;
        });
    }

    public static SingleConnectionFactory createConnectionFactory(ConnectionConfig config) {
        return SyncReplRunner.createConnectionFactory(config, ((SearchConnectionValidator.Builder)((SearchConnectionValidator.Builder)((SearchConnectionValidator.Builder)SearchConnectionValidator.builder().period(Duration.ofMinutes(1L))).timeout(Duration.ofSeconds(5L))).timeoutIsFailure(false)).build());
    }

    public static SingleConnectionFactory createConnectionFactory(ConnectionConfig config, ConnectionValidator validator) {
        return SyncReplRunner.createConnectionFactory(SyncReplRunner.createTransport(), config, validator);
    }

    public static SingleConnectionFactory createConnectionFactory(Transport transport, ConnectionConfig config, ConnectionValidator validator) {
        SingleConnectionFactory factory = new SingleConnectionFactory(config, transport);
        factory.setValidator(validator);
        SyncReplRunner.configureConnectionFactory(factory);
        return factory;
    }

    public static void configureConnectionFactory(SingleConnectionFactory factory) {
        AbstractConnectionValidator validator;
        ConnectionConfig newConfig = ConnectionConfig.copy(factory.getConnectionConfig());
        newConfig.setTransportOption("AUTO_READ", false);
        newConfig.setAutoReconnect(false);
        newConfig.setAutoReplay(false);
        factory.setConnectionConfig(newConfig);
        factory.setFailFastInitialize(false);
        factory.setNonBlockingInitialize(false);
        if (factory.getValidator() instanceof AbstractConnectionValidator && (validator = (AbstractConnectionValidator)factory.getValidator()).getOnFailure() == null) {
            validator.setOnFailure(factory.new SingleConnectionFactory.ReinitializeConnectionConsumer());
        }
    }

    private static Transport createTransport() {
        ConnectionFactoryTransport transport = new ConnectionFactoryTransport(SyncReplRunner.class.getSimpleName(), 1, 4);
        transport.setShutdownOnClose(false);
        return transport;
    }

    public void setOnStart(Supplier<Boolean> supplier) {
        this.onStart = supplier;
    }

    public void setOnEntry(Consumer<LdapEntry> consumer) {
        this.onEntry = consumer;
    }

    public void setOnReference(Consumer<SearchResultReference> consumer) {
        this.onReference = consumer;
    }

    public void setOnResult(Consumer<Result> consumer) {
        this.onResult = consumer;
    }

    public void setOnMessage(Consumer<SyncInfoMessage> consumer) {
        this.onMessage = consumer;
    }

    public void setOnException(Consumer<Exception> consumer) {
        this.onException = consumer;
    }

    public synchronized void initialize() {
        if (this.started) {
            throw new IllegalStateException("Runner has already been started");
        }
        this.syncReplClient.setOnEntry(this.onEntry);
        this.syncReplClient.setOnReference(this.onReference);
        this.syncReplClient.setOnResult(this.onResult);
        this.syncReplClient.setOnMessage(this.onMessage);
        this.syncReplClient.setOnException(this.onException);
    }

    public synchronized void start() {
        if (this.started) {
            throw new IllegalStateException("Runner has already been started");
        }
        try {
            if (this.onStart != null && !this.onStart.get().booleanValue()) {
                throw new RuntimeException("Start aborted from " + this.onStart);
            }
            LOGGER.debug("Starting runner {}", (Object)this);
            if (!((SingleConnectionFactory)this.syncReplClient.getConnectionFactory()).isInitialized()) {
                ((SingleConnectionFactory)this.syncReplClient.getConnectionFactory()).initialize();
            }
            this.started = true;
            LOGGER.info("Runner {} started", (Object)this);
        }
        catch (Exception e) {
            LOGGER.error("Could not start the runner", (Throwable)e);
        }
    }

    public synchronized void stop() {
        if (!this.started) {
            throw new IllegalStateException("Runner has not been started");
        }
        LOGGER.debug("Stopping runner {}", (Object)this);
        if (this.syncReplClient != null) {
            this.syncReplClient.close();
        }
        this.started = false;
        LOGGER.info("Runner {} stopped", (Object)this);
    }

    public boolean isStarted() {
        return this.started;
    }

    public synchronized void restartSearch() {
        if (!this.started) {
            throw new IllegalStateException("Cannot restart the search, runner is stopped");
        }
        try {
            if (!this.syncReplClient.isComplete()) {
                this.syncReplClient.cancel();
            }
        }
        catch (Exception e) {
            LOGGER.warn("Could not cancel sync repl request", (Throwable)e);
        }
        try {
            this.syncReplClient.send(this.searchRequest, this.cookieManager);
        }
        catch (LdapException e) {
            throw new IllegalStateException("Could not send sync repl request", e);
        }
    }

    public String toString() {
        return this.getClass().getName() + "@" + this.hashCode() + "::syncReplClient=" + this.syncReplClient + ", searchRequest=" + this.searchRequest + ", cookieManager=" + this.cookieManager + ", onStart=" + this.onStart + ", onEntry=" + this.onEntry + ", onReference=" + this.onReference + ", onResult=" + this.onResult + ", onMessage=" + this.onMessage + ", onException=" + this.onException + ", started=" + this.started;
    }
}

