/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.auth;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import org.ldaptive.LdapException;
import org.ldaptive.auth.AggregateEntryResolver;
import org.ldaptive.auth.DnResolver;
import org.ldaptive.auth.EntryResolver;
import org.ldaptive.auth.User;
import org.ldaptive.concurrent.CallableWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregateDnResolver
implements DnResolver {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final CallableWorker<String> callableWorker;
    private Map<String, DnResolver> dnResolvers = new HashMap<String, DnResolver>();
    private boolean allowMultipleDns;

    public AggregateDnResolver() {
        this.callableWorker = new CallableWorker(AggregateDnResolver.class.getSimpleName());
    }

    public AggregateDnResolver(Map<String, DnResolver> resolvers) {
        this.setDnResolvers(resolvers);
        this.callableWorker = new CallableWorker(AggregateDnResolver.class.getSimpleName());
    }

    public AggregateDnResolver(Map<String, DnResolver> resolvers, ExecutorService es) {
        this.setDnResolvers(resolvers);
        this.callableWorker = new CallableWorker(es);
    }

    public Map<String, DnResolver> getDnResolvers() {
        return Collections.unmodifiableMap(this.dnResolvers);
    }

    public void setDnResolvers(Map<String, DnResolver> resolvers) {
        this.logger.trace("setting dnResolvers: {}", resolvers);
        this.dnResolvers = resolvers;
    }

    public void addDnResolver(String label, DnResolver resolver) {
        this.logger.trace("adding dnResolver: {}:{}", (Object)label, (Object)resolver);
        this.dnResolvers.put(label, resolver);
    }

    public boolean getAllowMultipleDns() {
        return this.allowMultipleDns;
    }

    public void setAllowMultipleDns(boolean b) {
        this.logger.trace("setting allowMultipleDns: {}", (Object)b);
        this.allowMultipleDns = b;
    }

    public EntryResolver createEntryResolver(EntryResolver resolver) {
        HashMap<String, EntryResolver> resolvers = new HashMap<String, EntryResolver>(this.dnResolvers.size());
        for (String label : this.dnResolvers.keySet()) {
            resolvers.put(label, resolver);
        }
        return new AggregateEntryResolver(resolvers);
    }

    @Override
    public String resolve(User user) throws LdapException {
        ArrayList callables = new ArrayList();
        for (Map.Entry<String, DnResolver> entry : this.dnResolvers.entrySet()) {
            callables.add(() -> {
                this.logger.debug("Submitted DN resolver {}", entry.getValue());
                String dn = ((DnResolver)entry.getValue()).resolve(user);
                this.logger.debug("DN resolver {} resolved dn {} for user {}", new Object[]{entry.getValue(), dn, user});
                if (dn != null && !dn.isEmpty()) {
                    return String.format("%s:%s", entry.getKey(), dn);
                }
                return null;
            });
        }
        ArrayList results = new ArrayList(this.dnResolvers.size());
        List<ExecutionException> exceptions = this.callableWorker.execute(callables, s -> {
            if (s != null) {
                results.add(s);
            }
        });
        for (ExecutionException e : exceptions) {
            if (e.getCause() instanceof LdapException) {
                throw (LdapException)e.getCause();
            }
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            this.logger.warn("ExecutionException thrown, ignoring", (Throwable)e);
        }
        if (results.size() > 1 && !this.allowMultipleDns) {
            throw new LdapException("Found more than (1) DN for: " + user);
        }
        this.logger.debug("Resolved aggregate DN {}", results);
        return results.isEmpty() ? null : (String)results.get(0);
    }

    public void shutdown() {
        this.callableWorker.shutdown();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final AggregateDnResolver object = new AggregateDnResolver();

        protected Builder() {
        }

        public Builder resolver(String label, DnResolver resolver) {
            this.object.addDnResolver(label, resolver);
            return this;
        }

        public AggregateDnResolver build() {
            return this.object;
        }
    }
}

