/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.ldaptive.LdapURL;

public final class LdapURLActivatorService {
    private static final String ACTIVATOR_PERIOD_PROPERTY = "org.ldaptive.urlActivatorPeriod";
    private static final Duration ACTIVATOR_PERIOD = Duration.ofMinutes(Long.parseLong(System.getProperty("org.ldaptive.urlActivatorPeriod", "5")));
    private static final LdapURLActivatorService INSTANCE = new LdapURLActivatorService();
    private final List<LdapURL> inactiveUrls = new ArrayList<LdapURL>();
    private final ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, r -> {
        Thread t = new Thread(r, "ldaptive-" + this.getClass().getSimpleName() + "@" + this.hashCode());
        t.setDaemon(true);
        return t;
    });

    private LdapURLActivatorService() {
        this.executor.scheduleAtFixedRate(this::testInactiveUrls, ACTIVATOR_PERIOD.toMillis(), ACTIVATOR_PERIOD.toMillis(), TimeUnit.MILLISECONDS);
    }

    public static LdapURLActivatorService getInstance() {
        return INSTANCE;
    }

    public static Duration getPeriod() {
        return ACTIVATOR_PERIOD;
    }

    public void registerUrl(LdapURL url) {
        this.inactiveUrls.add(url);
    }

    public List<LdapURL> getInactiveUrls() {
        return Collections.unmodifiableList(this.inactiveUrls);
    }

    void testInactiveUrls() {
        for (LdapURL url : this.inactiveUrls) {
            if (url.isActive() || !url.getRetryMetadata().getConnectionStrategy().getRetryCondition().test(url)) continue;
            if (url.getRetryMetadata().getConnectionStrategy().getActivateCondition().test(url)) {
                url.getRetryMetadata().getConnectionStrategy().success(url);
                continue;
            }
            url.getRetryMetadata().recordFailure(Instant.now());
        }
        this.inactiveUrls.removeIf(LdapURL::isActive);
    }

    void clear() {
        this.inactiveUrls.clear();
    }
}

