/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive;

import java.util.Arrays;
import java.util.function.Consumer;
import org.ldaptive.AbstractConnectionValidator;
import org.ldaptive.Connection;
import org.ldaptive.OperationHandle;
import org.ldaptive.Request;
import org.ldaptive.Result;
import org.ldaptive.ResultCode;

public abstract class AbstractOperationConnectionValidator<Q extends Request, S extends Result>
extends AbstractConnectionValidator {
    private Q request;
    private ResultCode[] validResultCodes;

    public Q getRequest() {
        return this.request;
    }

    public void setRequest(Q req) {
        this.request = req;
    }

    public ResultCode[] getValidResultCodes() {
        return this.validResultCodes;
    }

    public void setValidResultCodes(ResultCode ... codes) {
        this.validResultCodes = codes;
    }

    protected abstract OperationHandle<Q, S> performOperation(Connection var1);

    @Override
    public void applyAsync(Connection conn, Consumer<Boolean> function) {
        if (conn == null) {
            function.accept(false);
        } else {
            OperationHandle<Q, S> h = this.performOperation(conn);
            h.onResult(r -> {
                if (this.validResultCodes != null) {
                    function.accept(Arrays.stream(this.validResultCodes).anyMatch(rc -> rc.equals((Object)r.getResultCode())));
                } else {
                    function.accept(r.getResultCode() != null);
                }
            });
            h.onException(e -> {
                if (e != null && e.getResultCode() == ResultCode.LDAP_TIMEOUT && !this.getTimeoutIsFailure()) {
                    this.logger.debug("Connection validator timeout ignored for {}", (Object)conn);
                    function.accept(true);
                } else {
                    this.logger.debug("Connection validator failed for {}", (Object)conn, e);
                    function.accept(false);
                }
            });
            h.send();
        }
    }

    @Override
    public String toString() {
        return super.toString() + ", request=" + this.request + ", validResultCodes=" + Arrays.toString((Object[])this.validResultCodes);
    }

    protected static abstract class AbstractBuilder<Q extends Request, S extends Result, B, T extends AbstractOperationConnectionValidator<Q, S>>
    extends AbstractConnectionValidator.AbstractBuilder<B, T> {
        protected AbstractBuilder(T t) {
            super(t);
        }

        @Override
        protected abstract B self();

        public B request(Q request) {
            ((AbstractOperationConnectionValidator)this.object).setRequest(request);
            return this.self();
        }

        public B validResultCodes(ResultCode ... codes) {
            ((AbstractOperationConnectionValidator)this.object).setValidResultCodes(codes);
            return this.self();
        }
    }
}

