/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.service.security.impl;

import javax.annotation.Nonnull;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.security.AccessControl;
import net.shibboleth.shared.security.AccessControlService;
import net.shibboleth.shared.spring.service.AbstractServiceableComponent;

public class ReloadingAccessControlService
extends AbstractServiceableComponent<AccessControlService>
implements AccessControlService {
    @Nonnull
    private final AccessControlService service;

    public ReloadingAccessControlService(@Nonnull @ParameterName(name="svc") AccessControlService svc) {
        this.service = (AccessControlService)Constraint.isNotNull((Object)svc, (String)"AccessControlService cannot be null");
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        String id = this.service.getId();
        if (id != null) {
            this.setId(id);
        } else if (this.getId() == null) {
            this.setId("UnNamedReloadingAccessControlService");
        }
        super.doInitialize();
    }

    @Nonnull
    public AccessControl getInstance(@Nonnull String name) {
        return this.service.getInstance(name);
    }

    @Override
    @Nonnull
    public AccessControlService getComponent() {
        return this;
    }
}

