/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.ticket;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.cas.protocol.ProtocolContext;
import net.shibboleth.idp.cas.ticket.TicketContext;
import net.shibboleth.idp.cas.ticket.TicketState;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;

public class TicketPrincipalLookupFunction
implements Function<ProfileRequestContext, String> {
    @Nonnull
    private Function<ProfileRequestContext, TicketContext> ticketContextLookupFunction = new ChildContextLookup(TicketContext.class).compose((Function)new ChildContextLookup(ProtocolContext.class));

    public void setTicketContextLookupFunction(@Nonnull Function<ProfileRequestContext, TicketContext> function) {
        this.ticketContextLookupFunction = (Function)Constraint.isNotNull(function, (String)"Ticket lookup function cannot be null");
    }

    @Override
    @Nullable
    public String apply(@Nullable ProfileRequestContext profileRequestContext) {
        TicketState state;
        TicketContext tc = this.ticketContextLookupFunction.apply(profileRequestContext);
        if (tc != null && (state = tc.getTicket().getTicketState()) != null) {
            return state.getPrincipalName();
        }
        return null;
    }
}

