/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.ticket;

import java.time.Instant;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.cas.ticket.Ticket;
import net.shibboleth.shared.primitive.StringSupport;

public class ProxyGrantingTicket
extends Ticket {
    @Nonnull
    private String proxyCallbackUrl;
    @Nullable
    private String parentPgTicketId;

    public ProxyGrantingTicket(@Nonnull String id, @Nonnull String service, @Nonnull Instant expiration, @Nonnull String pgtUrl, @Nullable String parentId) {
        super(id, service, expiration);
        this.proxyCallbackUrl = pgtUrl;
        this.parentPgTicketId = StringSupport.trimOrNull((String)parentId);
    }

    @Nonnull
    public String getProxyCallbackUrl() {
        return this.proxyCallbackUrl;
    }

    @Nullable
    public String getParentId() {
        return this.parentPgTicketId;
    }

    public boolean isRoot() {
        return this.getParentId() == null;
    }

    @Override
    protected Ticket newInstance(@Nonnull String newId) {
        return new ProxyGrantingTicket(newId, this.getService(), this.getExpirationInstant(), this.getProxyCallbackUrl(), this.parentPgTicketId);
    }
}

