/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.saml.saml2.profile.config.logic;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.profile.config.ProfileConfiguration;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.profile.context.logic.AbstractRelyingPartyPredicate;
import net.shibboleth.saml.saml2.profile.config.SAML2ProfileConfiguration;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class IgnoreRequestSignaturesPredicate
extends AbstractRelyingPartyPredicate {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(IgnoreRequestSignaturesPredicate.class);

    public boolean test(@Nullable ProfileRequestContext input) {
        ProfileConfiguration profileConfiguration;
        RelyingPartyContext rpCtx = this.getRelyingPartyContext(input);
        if (rpCtx != null && (profileConfiguration = rpCtx.getProfileConfig()) instanceof SAML2ProfileConfiguration) {
            SAML2ProfileConfiguration downcast = (SAML2ProfileConfiguration)profileConfiguration;
            return downcast.isIgnoreRequestSignatures(input);
        }
        this.log.debug("No SAML 2 profile configuration found, assuming signatures should be checked");
        return false;
    }
}

