/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cli.impl;

import com.google.common.base.Strings;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.Version;
import net.shibboleth.idp.cli.AbstractIdPHomeAwareCommandLine;
import net.shibboleth.idp.cli.impl.ModuleManagerArguments;
import net.shibboleth.idp.module.IdPModule;
import net.shibboleth.profile.module.Module;
import net.shibboleth.profile.module.ModuleContext;
import net.shibboleth.profile.module.ModuleException;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.cli.AbstractCommandLine;
import net.shibboleth.shared.cli.CommandLineArguments;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public final class ModuleManagerCLI
extends AbstractIdPHomeAwareCommandLine<ModuleManagerArguments> {
    @Nullable
    private Logger log;

    @Nonnull
    protected Logger getLogger() {
        if (this.log == null) {
            this.log = LoggerFactory.getLogger(ModuleManagerCLI.class);
        }
        assert (this.log != null);
        return this.log;
    }

    @Nonnull
    protected Class<ModuleManagerArguments> getArgumentClass() {
        return ModuleManagerArguments.class;
    }

    @Nonnull
    protected String getVersion() {
        String result = Version.getVersion();
        assert (result != null);
        return result;
    }

    @Nonnull
    @NotLive
    @Unmodifiable
    protected List<Resource> getAdditionalSpringResources() {
        return CollectionSupport.singletonList((Object)new ClassPathResource("net/shibboleth/idp/conf/http-client.xml"));
    }

    @Override
    protected int doRun(@Nonnull ModuleManagerArguments args) {
        int ret = super.doRun(args);
        if (ret != 0) {
            return ret;
        }
        try {
            ConfigurableEnvironment env = this.getApplicationContext().getEnvironment();
            assert (env != null);
            String idpHome = (String)Constraint.isNotNull((Object)env.getProperty("idp.home"), (String)"Property 'idp.home' not set");
            ModuleContext moduleContext = new ModuleContext(idpHome);
            moduleContext.setHttpClient(this.getHttpClient());
            moduleContext.setHttpClientSecurityParameters(this.getHttpClientSecurityParameters());
            moduleContext.setLanguageRanges(args.getLanguageRanges());
            if (args.getList() || !args.getInfoModuleIds().isEmpty() || !args.getTestModuleIds().isEmpty()) {
                return this.doList(moduleContext, args);
            }
            return this.doManage(moduleContext, args);
        }
        catch (ModuleException e) {
            System.out.println(e.getMessage());
            System.out.println(AbstractCommandLine.TerminalCodes.RED.code((CommandLineArguments)args) + "[FAILED]" + AbstractCommandLine.TerminalCodes.RESET.code((CommandLineArguments)args));
            System.out.println();
            return 1;
        }
    }

    private int doList(@Nonnull ModuleContext moduleContext, @Nonnull ModuleManagerArguments args) {
        int ret = 0;
        Iterator<IdPModule> modules = ServiceLoader.load(IdPModule.class).iterator();
        HashSet<String> unknownTestModules = new HashSet<String>(args.getTestModuleIds());
        HashSet<String> unknownInfoModules = new HashSet<String>(args.getInfoModuleIds());
        while (modules.hasNext()) {
            try {
                IdPModule module = modules.next();
                if (args.getTestModuleIds().contains(module.getId())) {
                    if (!module.isEnabled(moduleContext)) {
                        ret = -1;
                    }
                    unknownTestModules.remove(module.getId());
                }
                if (args.getInfoModuleIds().contains(module.getId())) {
                    System.out.println();
                    System.out.println("Module: " + module.getId());
                    System.out.println("\tName: " + module.getName(moduleContext));
                    System.out.println("\tDesc: " + module.getDescription(moduleContext));
                    if (module.getURL() != null) {
                        System.out.println("\tHelp: " + module.getURL());
                    }
                    if (module.isEnabled(moduleContext)) {
                        System.out.println("\tStatus: " + AbstractCommandLine.TerminalCodes.GREEN.code((CommandLineArguments)args) + "ENABLED" + AbstractCommandLine.TerminalCodes.RESET.code((CommandLineArguments)args));
                    } else {
                        System.out.println("\tStatus: " + AbstractCommandLine.TerminalCodes.RED.code((CommandLineArguments)args) + "DISABLED" + AbstractCommandLine.TerminalCodes.RESET.code((CommandLineArguments)args));
                    }
                    Collection resources = module.getResources();
                    resources.forEach(r -> System.out.println("\tResource: (" + (r.isReplace() ? "  replace" : "noreplace") + ") " + String.valueOf(r.getDestination())));
                    System.out.println();
                    unknownInfoModules.remove(module.getId());
                }
                if (!args.getInfoModuleIds().isEmpty() || !args.getTestModuleIds().isEmpty()) continue;
                System.out.print("Module: " + module.getId());
                if (module.isEnabled(moduleContext)) {
                    System.out.println(AbstractCommandLine.TerminalCodes.GREEN.code((CommandLineArguments)args) + " [ENABLED]" + AbstractCommandLine.TerminalCodes.RESET.code((CommandLineArguments)args));
                    continue;
                }
                System.out.println(AbstractCommandLine.TerminalCodes.RED.code((CommandLineArguments)args) + " [DISABLED]" + AbstractCommandLine.TerminalCodes.RESET.code((CommandLineArguments)args));
            }
            catch (ServiceConfigurationError e) {
                System.out.println("ServiceConfigurationError: " + e.getMessage());
            }
        }
        if (!unknownTestModules.isEmpty()) {
            return -1;
        }
        if (!unknownInfoModules.isEmpty()) {
            System.out.println("Unknown modules: " + String.valueOf(unknownInfoModules));
            return -1;
        }
        return ret;
    }

    private int doManage(@Nonnull ModuleContext moduleContext, @Nonnull ModuleManagerArguments args) throws ModuleException {
        int ret = 0;
        Iterator<IdPModule> modules = ServiceLoader.load(IdPModule.class).iterator();
        HashSet<String> unknownModules = new HashSet<String>(args.getEnableModuleIds());
        unknownModules.addAll(args.getDisableModuleIds());
        while (modules.hasNext()) {
            try {
                boolean enable;
                IdPModule module = modules.next();
                if (args.getEnableModuleIds().contains(module.getId())) {
                    enable = true;
                    unknownModules.remove(module.getId());
                } else {
                    if (!args.getDisableModuleIds().contains(module.getId())) continue;
                    enable = false;
                    unknownModules.remove(module.getId());
                }
                try (ByteArrayOutputStream sink = new ByteArrayOutputStream();){
                    System.out.println((enable ? "Enabling " : "Disabling ") + module.getId() + "...");
                    moduleContext.setMessageStream(new PrintStream(sink));
                    Map results = enable ? module.enable(moduleContext) : module.disable(moduleContext, args.getClean());
                    results.forEach(this::doReportOperation);
                    System.out.println(AbstractCommandLine.TerminalCodes.GREEN.code((CommandLineArguments)args) + "[OK]" + AbstractCommandLine.TerminalCodes.RESET.code((CommandLineArguments)args));
                    System.out.println();
                    String msg = sink.toString(Charset.forName("UTF-8"));
                    moduleContext.setMessageStream(null);
                    if (Strings.isNullOrEmpty((String)msg)) continue;
                    System.out.println(msg);
                    System.out.println();
                }
                catch (IOException e) {
                    this.getLogger().error("I/O Error", (Throwable)e);
                    ret = 2;
                }
            }
            catch (ServiceConfigurationError e) {
                System.out.println("ServiceConfigurationError: " + e.getMessage());
                ret = -1;
            }
        }
        if (!unknownModules.isEmpty()) {
            System.out.println("Unknown modules: " + String.valueOf(unknownModules));
            return -1;
        }
        return ret;
    }

    private void doReportOperation(@Nonnull Module.ModuleResource resource, @Nonnull Module.ResourceResult result) {
        System.out.print("\t" + String.valueOf(resource.getDestination()));
        switch (result) {
            case CREATED: {
                System.out.println(" created");
                break;
            }
            case REPLACED: {
                System.out.println(" replaced, " + String.valueOf(resource.getDestination()) + ".idpsave created");
                break;
            }
            case ADDED: {
                System.out.println(".idpnew created");
                break;
            }
            case REMOVED: {
                System.out.println(" removed");
                break;
            }
            case SAVED: {
                System.out.println(" renamed to " + String.valueOf(resource.getDestination()) + ".idpsave");
                break;
            }
            case MISSING: {
                System.out.println(" missing, nothing to do");
                break;
            }
        }
    }

    public static void main(@Nonnull String[] args) {
        System.exit(new ModuleManagerCLI().run(args));
    }
}

