/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cli.impl;

import com.beust.jcommander.Parameter;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.cli.AbstractIdPHomeAwareCommandLineArguments;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.slf4j.Logger;

public class ModuleManagerArguments
extends AbstractIdPHomeAwareCommandLineArguments {
    @Nullable
    private Logger log;
    @Parameter(names={"-l", "--list"})
    private boolean list;
    @Parameter(names={"-i", "--info"})
    @Nullable
    private List<String> infoModuleIds = new ArrayList<String>();
    @Parameter(names={"-t", "--test"})
    @Nullable
    private List<String> testModuleIds = new ArrayList<String>();
    @Parameter(names={"-e", "--enable"})
    @Nullable
    private List<String> enableModuleIds = new ArrayList<String>();
    @Parameter(names={"-d", "--disable"})
    @Nullable
    private List<String> disableModuleIds = new ArrayList<String>();
    @Parameter(names={"-f", "--clean"})
    private boolean clean;

    @Nonnull
    public Logger getLog() {
        if (this.log == null) {
            this.log = LoggerFactory.getLogger(ModuleManagerArguments.class);
        }
        assert (this.log != null);
        return this.log;
    }

    public boolean getList() {
        return this.list;
    }

    @Nonnull
    @NotLive
    @Unmodifiable
    public Collection<String> getInfoModuleIds() {
        return CollectionSupport.copyToList((Collection)StringSupport.normalizeStringCollection(this.infoModuleIds));
    }

    @Nonnull
    @NotLive
    @Unmodifiable
    public Collection<String> getTestModuleIds() {
        return CollectionSupport.copyToList((Collection)StringSupport.normalizeStringCollection(this.testModuleIds));
    }

    @Nonnull
    @NotLive
    @Unmodifiable
    public Collection<String> getEnableModuleIds() {
        return CollectionSupport.copyToList((Collection)StringSupport.normalizeStringCollection(this.enableModuleIds));
    }

    @Nonnull
    @NotLive
    @Unmodifiable
    public Collection<String> getDisableModuleIds() {
        return CollectionSupport.copyToList((Collection)StringSupport.normalizeStringCollection(this.disableModuleIds));
    }

    public boolean getClean() {
        return this.clean;
    }

    public void validate() throws IllegalArgumentException {
        super.validate();
        if (this.getEnableModuleIds().isEmpty() && this.getDisableModuleIds().isEmpty()) {
            if (this.getInfoModuleIds().isEmpty() && this.getTestModuleIds().isEmpty()) {
                this.list = true;
            }
        } else if (this.list || !this.getInfoModuleIds().isEmpty() || !this.getTestModuleIds().isEmpty()) {
            this.getLog().error("Cannot query and enable/disable in the same operation");
            throw new IllegalArgumentException("Cannot query and enable/disable in the same operation.");
        }
    }

    @Override
    public void printHelp(@Nonnull PrintStream out) {
        out.println("ModuleManager");
        out.println("Provides a command line interface for IdP Module management operations.");
        out.println();
        out.println("   module [options] [springConfiguration]");
        out.println();
        out.println("      springConfiguration      name of optional Spring configuration resource to use");
        super.printHelp(out);
        out.println();
        out.println(String.format("  %-22s %s", "-l, --list", "Brief Information on all installed modules"));
        out.println(String.format("  %-22s %s", "-i, --info <id>[,<id>]", "Full details on specific module(s)"));
        out.println(String.format("  %-22s %s", "-t, --test <id>[,<id>]", "Test specific module(s) for enablement"));
        out.println(String.format("  %-22s %s", "-e, --enable <id>[,<id>]", "Enable module(s)"));
        out.println(String.format("  %-22s %s", "-d, --disable <id>[,<id>]", "Disable module(s)"));
        out.println(String.format("  %-22s %s", "-f, --clean", "Clean disabled files instead of preserving them"));
        out.println();
    }
}

