/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import net.shibboleth.idp.cli.CommandLineArguments;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.codec.Base64Support;
import net.shibboleth.shared.codec.EncodingException;
import net.shibboleth.shared.primitive.StringSupport;

@Parameters(separators=" =")
public abstract class AbstractCommandLineArguments
implements CommandLineArguments {
    @Nonnull
    @NotEmpty
    public static final String BASEURL_PROPERTY = "net.shibboleth.idp.cli.baseURL";
    @Parameter(names={"-h", "--help"}, description="Display program usage", help=true)
    private boolean help;
    @Parameter(names={"-u", "--url"}, description="Base URL to invoke (path and query string will be appended)")
    @Nonnull
    private String url;
    @Parameter(names={"-p", "--path"}, description="Path to append to base URL to invoke")
    @Nullable
    private String path;
    @Parameter(names={"-k", "--disableNameChecking"}, description="Disable TLS certificate name checking")
    private boolean disableNameChecking;
    @Parameter(names={"-ts", "--trustStore"}, description="Path to a trust store for SSL connections")
    @Nullable
    private String trustStore;
    @Parameter(names={"-tt", "--trustStoreType"}, description="Type of trust store for SSL connections")
    @Nullable
    private String trustStoreType;
    @Parameter(names={"-tp", "--trustStorePassword"}, description="Password to a trust store for SSL connections")
    @Nullable
    private String trustStorePassword;
    @Parameter(names={"--username"}, required=false, description="Username to be used in HTTP-Basic Auth")
    @Nullable
    private String username;
    @Parameter(names={"--password"}, required=false, password=true, description="Password to be used in HTTP-Basic Auth")
    @Nullable
    private String password;
    @Parameter(names={"--method"}, required=false, description="")
    @Nullable
    @NotEmpty
    private String method;
    @Parameter(names={"--header"}, required=false, arity=2, description="HTTP header name and value")
    @Nullable
    private List<String> headers;

    public AbstractCommandLineArguments() {
        String u = System.getProperty(BASEURL_PROPERTY);
        if (u == null) {
            u = "http://localhost/idp";
        }
        this.url = u;
    }

    public boolean getHelp() {
        return this.help;
    }

    @Nonnull
    public String getURL() {
        return this.url;
    }

    @Nullable
    public String getPath() {
        return this.path;
    }

    @Nullable
    public String getTrustStore() {
        return this.trustStore;
    }

    @Nullable
    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    @Nullable
    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public boolean isDisableNameChecking() {
        return this.disableNameChecking;
    }

    @Nullable
    public String getUsername() {
        return this.username;
    }

    @Nullable
    public String getPassword() {
        return this.password;
    }

    @Override
    @Nullable
    @NotEmpty
    public String getMethod() {
        return StringSupport.trimOrNull((String)this.method);
    }

    @Override
    @Nullable
    @NotLive
    @Unmodifiable
    public Map<String, String> getHeaders() {
        List<String> hdrs = this.headers;
        if (hdrs != null) {
            HashMap<String, String> map = new HashMap<String, String>();
            Iterator<String> iter = hdrs.iterator();
            while (iter.hasNext()) {
                String h = iter.next();
                if (!iter.hasNext()) continue;
                String v = iter.next();
                if (h == null || v == null) continue;
                if (map.containsKey(h)) {
                    map.put(h, ((String)map.get(h)).concat(",").concat(v));
                    continue;
                }
                map.put(h, v);
            }
            return map;
        }
        return null;
    }

    @Override
    public boolean isUsage() {
        return this.help;
    }

    @Override
    public void validate() {
    }

    @Override
    @Nonnull
    public URL buildURL() throws MalformedURLException {
        this.installTrustStore();
        if (this.disableNameChecking) {
            HostnameVerifier allHostsValid = new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            };
            HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
        }
        StringBuilder builder = new StringBuilder(this.getURL());
        if (this.getPath() != null) {
            builder.append(this.getPath());
        }
        return new URL(this.doBuildURL(builder).toString());
    }

    @Nonnull
    protected StringBuilder doBuildURL(@Nonnull StringBuilder builder) {
        return builder;
    }

    @Override
    @Nullable
    @NotEmpty
    public String getBasicAuthHeader() {
        if (StringSupport.trimOrNull((String)this.username) == null || StringSupport.trimOrNull((String)this.password) == null) {
            return null;
        }
        String rawHeader = this.username + ":" + this.password;
        try {
            byte[] bytes = rawHeader.getBytes(StandardCharsets.UTF_8);
            assert (bytes != null);
            return "Basic " + Base64Support.encode((byte[])bytes, (boolean)false);
        }
        catch (EncodingException e) {
            System.err.println(e.getMessage());
            return null;
        }
    }

    private void installTrustStore() {
        if (this.trustStoreType != null) {
            System.setProperty("javax.net.ssl.trustStore", this.trustStore);
            if (this.trustStoreType != null) {
                System.setProperty("javax.net.ssl.trustStoreType", this.trustStoreType);
            }
            if (this.trustStorePassword != null) {
                System.setProperty("javax.net.ssl.trustStorePassword", this.trustStorePassword);
            }
        }
    }
}

