/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.transcoding.impl;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.transcoding.AttributeTranscoder;
import net.shibboleth.idp.attribute.transcoding.AttributeTranscoderRegistry;
import net.shibboleth.idp.attribute.transcoding.TranscodingRule;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.DeprecationSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

@ThreadSafe
public class AttributeTranscoderRegistryImpl
extends AbstractIdentifiableInitializableComponent
implements AttributeTranscoderRegistry,
ApplicationContextAware {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AttributeTranscoderRegistryImpl.class);
    @Nonnull
    private final Map<String, Multimap<Class<?>, TranscodingRule>> transcodingRegistry = new HashMap();
    @Nonnull
    private final Map<String, Map<Locale, String>> displayNameRegistry;
    @Nonnull
    private final Map<String, Map<Locale, String>> descriptionRegistry;
    @Nonnull
    private final Map<Class<?>, Function<?, String>> namingFunctionRegistry = new HashMap();
    @Nullable
    private Function<Map<String, Object>, Predicate<ProfileRequestContext>> extendedConditionFactory;
    @Nullable
    private ApplicationContext applicationContext;

    public AttributeTranscoderRegistryImpl() {
        this.displayNameRegistry = new HashMap<String, Map<Locale, String>>();
        this.descriptionRegistry = new HashMap<String, Map<Locale, String>>();
    }

    public void setApplicationContext(@Nullable ApplicationContext context) {
        this.checkSetterPreconditions();
        this.applicationContext = context;
    }

    @Nullable
    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setNamingRegistry(@Nullable Collection<AttributeTranscoderRegistry.NamingFunction<?>> registry) {
        this.checkSetterPreconditions();
        this.namingFunctionRegistry.clear();
        if (registry != null) {
            registry.forEach(nf -> this.namingFunctionRegistry.put(nf.getType(), nf.getFunction()));
        }
    }

    public void setTranscoderRegistry(@Nonnull Collection<TranscodingRule> mappings) {
        this.checkSetterPreconditions();
        Constraint.isNotNull(mappings, (String)"Mappings cannot be null");
        this.transcodingRegistry.clear();
        for (TranscodingRule mapping : mappings) {
            String internalId = StringSupport.trimOrNull((String)((String)mapping.get("id", String.class)));
            if (internalId != null && !IdPAttribute.isInvalidId((String)internalId)) {
                Predicate<ProfileRequestContext> activationCondition;
                if (IdPAttribute.isDeprecatedId((String)internalId)) {
                    DeprecationSupport.warn((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.CONFIGURATION, (String)"TranscodingRule", (String)"TranscodingRule id with special characters ('\"%{})", null);
                }
                if ((activationCondition = this.buildActivationCondition(mapping.getMap())) != null) {
                    mapping.getMap().put("activationCondition", activationCondition);
                } else {
                    mapping.getMap().remove("activationCondition");
                }
                Collection<AttributeTranscoder<?>> transcoders = this.getAttributeTranscoders(mapping);
                for (AttributeTranscoder<?> transcoder : transcoders) {
                    assert (transcoder != null);
                    this.addMapping(internalId, transcoder, mapping.getMap());
                }
                continue;
            }
            this.log.warn("Ignoring TranscodingRule with invalid id property: {}", (Object)internalId);
        }
    }

    public void setExtendedConditionFactory(@Nullable Function<Map<String, Object>, Predicate<ProfileRequestContext>> factory) {
        this.checkSetterPreconditions();
        this.extendedConditionFactory = factory;
    }

    @Nonnull
    @NotLive
    @Unmodifiable
    public Map<Locale, String> getDisplayNames(@Nonnull IdPAttribute attribute) {
        this.checkComponentActive();
        Constraint.isNotNull((Object)attribute, (String)"IdPAttribute cannot be null");
        Map<Locale, String> map = this.displayNameRegistry.get(attribute.getId());
        if (map != null) {
            return map;
        }
        return CollectionSupport.emptyMap();
    }

    @Nonnull
    @NotLive
    @Unmodifiable
    public Map<Locale, String> getDescriptions(@Nonnull IdPAttribute attribute) {
        this.checkComponentActive();
        Constraint.isNotNull((Object)attribute, (String)"IdPAttribute cannot be null");
        Map<Locale, String> map = this.descriptionRegistry.get(attribute.getId());
        if (map != null) {
            return map;
        }
        return CollectionSupport.emptyMap();
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public Collection<TranscodingRule> getTranscodingRules(@Nonnull IdPAttribute from, @Nonnull Class<?> to) {
        this.checkComponentActive();
        Constraint.isNotNull((Object)from, (String)"IdPAttribute cannot be null");
        Constraint.isNotNull(to, (String)"Target type cannot be null");
        Multimap<Class<?>, TranscodingRule> propertyCollections = this.transcodingRegistry.get(from.getId());
        if (propertyCollections == null) {
            return CollectionSupport.emptyList();
        }
        Class<?> effectiveType = this.getEffectiveType(to);
        if (effectiveType == null) {
            this.log.warn("Unsupported object type: {}", (Object)to.getClass().getName());
            return CollectionSupport.emptyList();
        }
        this.log.trace("Using rules for effective type {}", (Object)effectiveType.getName());
        Collection result = propertyCollections.get(effectiveType);
        assert (result != null);
        return CollectionSupport.copyToList((Collection)result);
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public <T> Collection<TranscodingRule> getTranscodingRules(@Nonnull T from) {
        this.checkComponentActive();
        Constraint.isNotNull(from, (String)"Input object cannot be null");
        Class<?> effectiveType = this.getEffectiveType(from.getClass());
        if (effectiveType == null) {
            this.log.warn("Unsupported object type: {}", (Object)from.getClass().getName());
            return CollectionSupport.emptyList();
        }
        this.log.trace("Using rules for effective type {}", (Object)effectiveType.getName());
        Function<?, String> namingFunction = this.namingFunctionRegistry.get(effectiveType);
        String id = namingFunction.apply(from);
        if (id != null) {
            Multimap<Class<?>, TranscodingRule> propertyCollections = this.transcodingRegistry.get(id);
            if (propertyCollections == null) {
                return CollectionSupport.emptyList();
            }
            Collection result = propertyCollections.get(effectiveType);
            assert (result != null);
            return CollectionSupport.copyToList((Collection)result);
        }
        this.log.warn("Object of type {} did not have a canonical name", (Object)from.getClass().getName());
        return CollectionSupport.emptyList();
    }

    @Nonnull
    private Collection<AttributeTranscoder<?>> getAttributeTranscoders(@Nonnull TranscodingRule rule) {
        AttributeTranscoder transcoder = (AttributeTranscoder)rule.get("transcoder", AttributeTranscoder.class);
        if (transcoder != null) {
            return CollectionSupport.singletonList((Object)transcoder);
        }
        String beanNames = (String)rule.get("transcoder", String.class);
        if (beanNames == null) {
            this.log.error("{} property is missing or of incorrect type", (Object)"transcoder");
            return CollectionSupport.emptyList();
        }
        ArrayList transcoders = new ArrayList();
        ApplicationContext appContext = this.getApplicationContext();
        if (appContext != null) {
            for (String id : StringSupport.stringToList((String)beanNames, (String)" ")) {
                try {
                    assert (id != null);
                    transcoder = (AttributeTranscoder)appContext.getBean(id, AttributeTranscoder.class);
                    transcoder.initialize();
                    transcoders.add(transcoder);
                }
                catch (Exception e) {
                    this.log.error("Unable to locate AttributeTranscoder bean named {}", (Object)id, (Object)e);
                }
            }
        } else {
            this.log.error("Unable to locate AttributeTranscoder beans, ApplicationContext was null");
        }
        return transcoders;
    }

    private void addMapping(@Nonnull @NotEmpty String id, @Nonnull AttributeTranscoder<?> transcoder, @Nonnull Map<String, Object> ruleset) {
        Boolean decoder;
        TranscodingRule copy = new TranscodingRule(ruleset);
        copy.getMap().put("transcoder", transcoder);
        Class type = transcoder.getEncodedType();
        String targetName = transcoder.getEncodedName(copy);
        Boolean encoder = (Boolean)copy.getOrDefault("encoder", Boolean.class, (Object)true);
        if (encoder == null) {
            encoder = true;
        }
        if ((decoder = (Boolean)copy.getOrDefault("decoder", Boolean.class, (Object)true)) == null) {
            decoder = true;
        }
        if (decoder.booleanValue() && targetName == null) {
            this.log.warn("Transcoding rule for {} and type {} did not produce a decodable target name, disabling decoding", (Object)id, (Object)type.getName());
            decoder = false;
        }
        if (!encoder.booleanValue() && !decoder.booleanValue()) {
            this.log.warn("Transcoding rule for {} and type {} was disabled in both directions, ignoring", (Object)id, (Object)type.getName());
            return;
        }
        if (targetName != null) {
            this.log.debug("Attribute mapping: {} {}-{} {} via {}", new Object[]{id, decoder != false ? "<" : "", encoder != false ? ">" : "", targetName, transcoder.getClass().getSimpleName()});
        } else {
            this.log.debug("Attribute mapping: {} {}-{} (metadata-driven naming only) via {}", new Object[]{id, decoder != false ? "<" : "", encoder != false ? ">" : "", transcoder.getClass().getSimpleName()});
        }
        copy.getMap().put("id", id);
        if (encoder.booleanValue()) {
            ArrayListMultimap rulesetsForIdPName = this.transcodingRegistry.get(id);
            if (rulesetsForIdPName == null) {
                rulesetsForIdPName = ArrayListMultimap.create();
                this.transcodingRegistry.put(id, (Multimap<Class<?>, TranscodingRule>)rulesetsForIdPName);
            }
            rulesetsForIdPName.put((Object)type, (Object)copy);
        }
        if (targetName != null && decoder.booleanValue()) {
            ArrayListMultimap rulesetsForEncodedName = this.transcodingRegistry.get(targetName);
            if (rulesetsForEncodedName == null) {
                rulesetsForEncodedName = ArrayListMultimap.create();
                this.transcodingRegistry.put(targetName, (Multimap<Class<?>, TranscodingRule>)rulesetsForEncodedName);
            }
            rulesetsForEncodedName.put((Object)type, (Object)copy);
        }
        if (this.displayNameRegistry.containsKey(id)) {
            this.displayNameRegistry.get(id).putAll(copy.getDisplayNames());
        } else {
            this.displayNameRegistry.put(id, new HashMap(copy.getDisplayNames()));
        }
        if (this.descriptionRegistry.containsKey(id)) {
            this.descriptionRegistry.get(id).putAll(copy.getDescriptions());
        } else {
            this.descriptionRegistry.put(id, new HashMap(copy.getDescriptions()));
        }
    }

    @Nullable
    private Predicate<ProfileRequestContext> buildActivationCondition(@Nonnull Map<String, Object> ruleset) {
        Predicate<ProfileRequestContext> extendedCondition;
        Predicate effectiveCondition;
        block10: {
            effectiveCondition = null;
            Object baseCondition = ruleset.get("activationCondition");
            if (baseCondition instanceof Predicate) {
                effectiveCondition = (Predicate)baseCondition;
            } else if (baseCondition instanceof String) {
                try {
                    ApplicationContext appContext = this.getApplicationContext();
                    if (appContext != null) {
                        effectiveCondition = (Predicate)appContext.getBean((String)baseCondition, Predicate.class);
                        break block10;
                    }
                    this.log.error("Unable to locate Predicate bean named {}, ApplicationContext was null", baseCondition);
                }
                catch (Exception e) {
                    this.log.error("Unable to locate Predicate bean named {}", baseCondition, (Object)e);
                }
            } else if (baseCondition != null) {
                this.log.error("{} property did not contain a Predicate object, ignored", (Object)"activationCondition");
            }
        }
        Predicate<ProfileRequestContext> predicate = extendedCondition = this.extendedConditionFactory != null ? this.extendedConditionFactory.apply(ruleset) : null;
        if (effectiveCondition == null) {
            return extendedCondition;
        }
        if (extendedCondition != null) {
            return effectiveCondition.and(extendedCondition);
        }
        return effectiveCondition;
    }

    @Nullable
    private Class<?> getEffectiveType(@Nonnull Class<?> inputType) {
        if (this.namingFunctionRegistry.containsKey(inputType)) {
            return inputType;
        }
        for (Class<?> candidate : this.namingFunctionRegistry.keySet()) {
            if (!candidate.isAssignableFrom(inputType)) continue;
            return candidate;
        }
        return null;
    }
}

