/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.transcoding.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.transcoding.AttributeTranscoderRegistry;
import net.shibboleth.idp.attribute.transcoding.TranscodingRule;
import net.shibboleth.idp.attribute.transcoding.impl.AttributeTranscoderRegistryImpl;
import net.shibboleth.idp.attribute.transcoding.impl.TranscodingRuleLoader;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.NonnullFunction;
import net.shibboleth.shared.service.ServiceException;
import net.shibboleth.shared.spring.service.AbstractServiceableComponent;
import net.shibboleth.shared.spring.service.impl.SpringServiceableComponent;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class AttributeRegistryServiceStrategy
extends AbstractIdentifiableInitializableComponent
implements NonnullFunction<ApplicationContext, AbstractServiceableComponent<AttributeTranscoderRegistry>> {
    @Nullable
    private Collection<AttributeTranscoderRegistry.NamingFunction<?>> namingRegistry;
    @Nullable
    private Function<Map<String, Object>, Predicate<ProfileRequestContext>> extendedConditionFactory;

    @Autowired
    public void setNamingRegistry(@Nullable Collection<AttributeTranscoderRegistry.NamingFunction<?>> namingFunctions) {
        this.checkSetterPreconditions();
        this.namingRegistry = namingFunctions != null ? CollectionSupport.copyToList(namingFunctions) : CollectionSupport.emptyList();
    }

    public void setExtendedConditionFactory(@Nullable Function<Map<String, Object>, Predicate<ProfileRequestContext>> factory) {
        this.checkSetterPreconditions();
        this.extendedConditionFactory = factory;
    }

    @Nonnull
    public AbstractServiceableComponent<AttributeTranscoderRegistry> apply(@Nullable ApplicationContext appContext) {
        this.checkComponentActive();
        if (appContext == null) {
            throw new ServiceException("ApplicationContext was null");
        }
        Collection mappingBeans = appContext.getBeansOfType(TranscodingRule.class).values();
        Collection loaderBeans = appContext.getBeansOfType(TranscodingRuleLoader.class).values();
        ArrayList<TranscodingRule> holder = new ArrayList<TranscodingRule>();
        if (mappingBeans != null) {
            holder.addAll(mappingBeans);
        }
        if (loaderBeans != null) {
            loaderBeans.forEach(loader -> holder.addAll(loader.getRules()));
        }
        AttributeTranscoderRegistryImpl registry = new AttributeTranscoderRegistryImpl();
        registry.setId(this.ensureId());
        registry.setApplicationContext(appContext);
        registry.setNamingRegistry(this.namingRegistry);
        registry.setExtendedConditionFactory(this.extendedConditionFactory);
        registry.setTranscoderRegistry(holder);
        try {
            registry.initialize();
            SpringServiceableComponent result = new SpringServiceableComponent((Object)registry);
            result.setApplicationContext(appContext);
            result.initialize();
            return result;
        }
        catch (ComponentInitializationException e) {
            throw new ServiceException("Unable to initialize attribute transcoder registry for " + appContext.getDisplayName(), (Exception)((Object)e));
        }
    }
}

