/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.authn.AbstractAuthenticationAction;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.RequestedPrincipalContext;
import net.shibboleth.idp.saml.authn.principal.AuthnContextClassRefPrincipal;
import net.shibboleth.idp.saml.authn.principal.AuthnContextDeclRefPrincipal;
import net.shibboleth.profile.config.ProfileConfiguration;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.context.navigate.MessageLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.opensaml.saml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml.saml2.core.AuthnContextComparisonTypeEnumeration;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.RequestedAuthnContext;
import org.slf4j.Logger;

public class ProcessRequestedAuthnContext
extends AbstractAuthenticationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ProcessRequestedAuthnContext.class);
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class);
    @Nonnull
    private Function<ProfileRequestContext, AuthnRequest> authnRequestLookupStrategy;
    @Nonnull
    private Set<String> ignoredContexts;
    @NonnullBeforeExec
    private AuthnRequest authnRequest;

    public ProcessRequestedAuthnContext() {
        Function arls = new MessageLookup(AuthnRequest.class).compose((Function)new InboundMessageContextLookup());
        assert (arls != null);
        this.authnRequestLookupStrategy = arls;
        this.ignoredContexts = CollectionSupport.singleton((Object)"urn:oasis:names:tc:SAML:2.0:ac:classes:unspecified");
    }

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        this.checkSetterPreconditions();
        this.relyingPartyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext lookup strategy cannot be null");
    }

    public void setAuthnRequestLookupStrategy(@Nonnull Function<ProfileRequestContext, AuthnRequest> strategy) {
        this.checkSetterPreconditions();
        this.authnRequestLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AuthnRequest lookup strategy cannot be null");
    }

    public void setIgnoredContexts(@Nonnull Collection<String> contexts) {
        this.checkSetterPreconditions();
        Collection trimmed = StringSupport.normalizeStringCollection(contexts);
        this.ignoredContexts = trimmed.isEmpty() ? CollectionSupport.emptySet() : CollectionSupport.copyToSet((Collection)trimmed);
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        this.checkComponentActive();
        if (!super.doPreExecute(profileRequestContext, authenticationContext)) {
            return false;
        }
        this.authnRequest = this.authnRequestLookupStrategy.apply(profileRequestContext);
        if (this.authnRequest == null) {
            this.log.debug("{} AuthnRequest message was not returned by lookup strategy", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        ProfileConfiguration profileConfig;
        RequestedAuthnContext requestedCtx = this.authnRequest.getRequestedAuthnContext();
        if (requestedCtx == null) {
            this.log.debug("{} AuthnRequest did not contain a RequestedAuthnContext, nothing to do", (Object)this.getLogPrefix());
            return;
        }
        ArrayList<Object> principals = new ArrayList<Object>();
        if (!requestedCtx.getAuthnContextClassRefs().isEmpty()) {
            for (AuthnContextClassRef ref : requestedCtx.getAuthnContextClassRefs()) {
                uri = ref.getURI();
                if (uri == null) continue;
                if (!this.ignoredContexts.contains(uri)) {
                    principals.add(new AuthnContextClassRefPrincipal(uri));
                    continue;
                }
                this.log.info("{} Ignoring AuthnContextClassRef: {}", (Object)this.getLogPrefix(), (Object)ref.getURI());
            }
        } else if (!requestedCtx.getAuthnContextDeclRefs().isEmpty()) {
            for (AuthnContextClassRef ref : requestedCtx.getAuthnContextDeclRefs()) {
                uri = ref.getURI();
                if (uri == null) continue;
                if (!this.ignoredContexts.contains(uri)) {
                    principals.add(new AuthnContextDeclRefPrincipal(uri));
                    continue;
                }
                this.log.info("{} Ignoring AuthnContextDeclRef: {}", (Object)this.getLogPrefix(), (Object)ref.getURI());
            }
        }
        if (principals.isEmpty()) {
            this.log.debug("{} RequestedAuthnContext did not contain any requested contexts, nothing to do", (Object)this.getLogPrefix());
            return;
        }
        RelyingPartyContext rpContext = this.relyingPartyContextLookupStrategy.apply(profileRequestContext);
        ProfileConfiguration profileConfiguration = profileConfig = rpContext == null ? null : rpContext.getProfileConfig();
        if (profileConfig != null && profileConfig.isFeatureDisallowed(profileRequestContext, 1)) {
            this.log.warn("{} Incoming RequestedAuthnContext disallowed by profile configuration", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"AccessDenied");
            return;
        }
        RequestedPrincipalContext rpCtx = new RequestedPrincipalContext();
        AuthnContextComparisonTypeEnumeration operator = requestedCtx.getComparison();
        if (operator != null) {
            rpCtx.setOperator(operator.toString());
        } else {
            rpCtx.setOperator(AuthnContextComparisonTypeEnumeration.EXACT.toString());
        }
        rpCtx.setRequestedPrincipals(principals);
        authenticationContext.addSubcontext((BaseContext)rpCtx, true);
        this.log.debug("{} RequestedPrincipalContext created with operator {} and {} custom principal(s)", new Object[]{this.getLogPrefix(), rpCtx.getOperator(), principals.size()});
    }
}

