/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml1.profile.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.saml.profile.impl.BaseIdPInitiatedSSORequestMessageDecoder;
import net.shibboleth.idp.saml.profile.impl.IdPInitiatedSSORequest;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.opensaml.saml.common.messaging.context.SAMLBindingContext;
import org.opensaml.saml.common.messaging.context.SAMLMessageInfoContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.slf4j.Logger;

public class IdPInitiatedSSORequestMessageDecoder
extends BaseIdPInitiatedSSORequestMessageDecoder {
    @Nonnull
    @NotEmpty
    private static final String BINDING_URI = "urn:mace:shibboleth:1.0:profiles:AuthnRequest";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(IdPInitiatedSSORequestMessageDecoder.class);

    @Nonnull
    @NotEmpty
    public String getBindingURI() {
        return BINDING_URI;
    }

    protected void doDecode() throws MessageDecodingException {
        IdPInitiatedSSORequest ssoRequest = this.buildIdPInitiatedSSORequest();
        MessageContext messageContext = new MessageContext();
        messageContext.setMessage((Object)ssoRequest);
        ((SAMLPeerEntityContext)messageContext.ensureSubcontext(SAMLPeerEntityContext.class)).setEntityId(ssoRequest.getEntityId());
        SAMLMessageInfoContext msgInfoContext = (SAMLMessageInfoContext)messageContext.ensureSubcontext(SAMLMessageInfoContext.class);
        msgInfoContext.setMessageIssueInstant(ssoRequest.getTime());
        msgInfoContext.setMessageId(this.getMessageID());
        this.populateBindingContext(messageContext);
        this.setMessageContext(messageContext);
    }

    protected void populateBindingContext(@Nonnull MessageContext messageContext) throws MessageDecodingException {
        IdPInitiatedSSORequest message = (IdPInitiatedSSORequest)Constraint.isNotNull((Object)((IdPInitiatedSSORequest)messageContext.getMessage()), (String)"No message");
        String relayState = message.getRelayState();
        if (relayState == null) {
            throw new MessageDecodingException("Legacy Shibboleth authentication requests require a target parameter");
        }
        this.log.debug("Decoded SAML relay state: {}", (Object)relayState);
        SAMLBindingContext bindingContext = (SAMLBindingContext)messageContext.ensureSubcontext(SAMLBindingContext.class);
        bindingContext.setRelayState(relayState);
        bindingContext.setBindingUri(this.getBindingURI());
        bindingContext.setBindingDescriptor(this.getBindingDescriptor());
        bindingContext.setHasBindingSignature(false);
        bindingContext.setIntendedDestinationEndpointURIRequired(false);
    }

    @Nullable
    protected String serializeMessageForLogging(@Nullable Object message) {
        if (message == null) {
            this.log.debug("Message was null, can not serialize");
            return null;
        }
        return "SAML 1 IdP-initiated request was: " + message.toString();
    }
}

