/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.profile.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.ThreadSafeAfterInit;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.messaging.decoder.MessageDecoder;
import org.slf4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

@ThreadSafeAfterInit
public class SpringAwareMessageDecoderFactory
extends AbstractInitializableComponent
implements Function<String, MessageDecoder>,
ApplicationContextAware {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SpringAwareMessageDecoderFactory.class);
    @Nullable
    private ApplicationContext applicationContext;
    @Nonnull
    private Map<String, String> beanMappings = CollectionSupport.emptyMap();

    public void setBeanMappings(@Nonnull Map<String, String> mappings) {
        this.checkSetterPreconditions();
        Constraint.isNotNull(mappings, (String)"Mappings cannot be null");
        this.beanMappings = new HashMap<String, String>(mappings.size());
        for (Map.Entry<String, String> entry : mappings.entrySet()) {
            String key = StringSupport.trimOrNull((String)entry.getKey());
            String value = StringSupport.trimOrNull((String)entry.getValue());
            if (key == null || value == null) continue;
            this.beanMappings.put(key, value);
        }
    }

    public void setApplicationContext(@Nullable ApplicationContext context) {
        this.applicationContext = context;
    }

    @Override
    @Nullable
    public MessageDecoder apply(@Nullable String input) {
        this.checkComponentActive();
        String beanID = this.beanMappings.get(StringSupport.trimOrNull((String)input));
        if (this.applicationContext == null) {
            this.log.warn("No Spring ApplicationContext set");
            return null;
        }
        if (beanID == null) {
            this.log.warn("No bean ID associated with input value {}", (Object)input);
            return null;
        }
        this.log.debug("Looking up message decoder with bean ID: {}", (Object)beanID);
        try {
            assert (this.applicationContext != null);
            return (MessageDecoder)this.applicationContext.getBean(beanID, MessageDecoder.class);
        }
        catch (BeansException e) {
            this.log.warn("Error instantiating message decoder from bean ID {}", (Object)beanID, (Object)e);
            return null;
        }
    }
}

