/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.profile.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.saml.profile.config.SAMLProfileConfiguration;
import net.shibboleth.idp.saml.profile.impl.IdPInitiatedSSORequest;
import net.shibboleth.idp.saml.saml2.profile.config.BrowserSSOProfileConfiguration;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.saml.profile.config.SAMLArtifactAwareProfileConfiguration;
import net.shibboleth.saml.profile.config.SAMLArtifactConfiguration;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.FunctionSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.Criterion;
import net.shibboleth.shared.resolver.ResolverException;
import org.opensaml.core.xml.XMLObjectBuilder;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.messaging.context.MessageChannelSecurityContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.OutboundMessageContextLookup;
import org.opensaml.saml.common.binding.BindingDescriptor;
import org.opensaml.saml.common.binding.EndpointResolver;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.common.messaging.context.SAMLArtifactContext;
import org.opensaml.saml.common.messaging.context.SAMLBindingContext;
import org.opensaml.saml.common.messaging.context.SAMLEndpointContext;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.criterion.BestMatchLocationCriterion;
import org.opensaml.saml.criterion.BindingCriterion;
import org.opensaml.saml.criterion.EndpointCriterion;
import org.opensaml.saml.criterion.RoleDescriptorCriterion;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.opensaml.saml.saml2.metadata.IndexedEndpoint;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.slf4j.Logger;

public class PopulateBindingAndEndpointContexts
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PopulateBindingAndEndpointContexts.class);
    @Nullable
    private QName endpointType;
    @NonnullAfterInit
    private EndpointResolver<?> endpointResolver;
    @Nonnull
    private Function<ProfileRequestContext, List<BindingDescriptor>> bindingDescriptorsLookupStrategy = FunctionSupport.constant((Object)CollectionSupport.emptyList());
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class);
    @Nonnull
    private Function<ProfileRequestContext, SAMLMetadataContext> metadataContextLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, SAMLBindingContext> bindingContextLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, SAMLEndpointContext> endpointContextLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, SAMLArtifactContext> artifactContextLookupStrategy;
    @Nullable
    private Function<ProfileRequestContext, BestMatchLocationCriterion> bestMatchCriterionLookupStrategy;
    @NonnullBeforeExec
    private List<BindingDescriptor> bindingDescriptors;
    private boolean artifactImpliesSecureChannel;
    @NonnullAfterInit
    private XMLObjectBuilder<?> endpointBuilder;
    @Nullable
    private SAMLArtifactConfiguration artifactConfiguration;
    @Nullable
    private Object inboundMessage;
    @Nullable
    private String relyingPartyId;
    @Nullable
    private SAMLMetadataContext mdContext;
    private boolean verified;
    private boolean skipValidationSinceSigned;

    public PopulateBindingAndEndpointContexts() {
        Function mcls = new ChildContextLookup(SAMLMetadataContext.class).compose(new ChildContextLookup(SAMLPeerEntityContext.class).compose((Function)new OutboundMessageContextLookup()));
        assert (mcls != null);
        this.metadataContextLookupStrategy = mcls;
        Function bcs = new ChildContextLookup(SAMLBindingContext.class, true).compose((Function)new OutboundMessageContextLookup());
        assert (bcs != null);
        this.bindingContextLookupStrategy = bcs;
        Function acs = new ChildContextLookup(SAMLArtifactContext.class, true).compose((Function)new OutboundMessageContextLookup());
        assert (acs != null);
        this.artifactContextLookupStrategy = acs;
        Function ecls = new ChildContextLookup(SAMLEndpointContext.class, true).compose(new ChildContextLookup(SAMLPeerEntityContext.class, true).compose((Function)new OutboundMessageContextLookup()));
        assert (ecls != null);
        this.endpointContextLookupStrategy = ecls;
        this.artifactImpliesSecureChannel = true;
    }

    public void setEndpointType(@Nullable QName type) {
        this.checkSetterPreconditions();
        this.endpointType = type;
    }

    public void setEndpointResolver(@Nonnull EndpointResolver<?> resolver) {
        this.checkSetterPreconditions();
        this.endpointResolver = (EndpointResolver)Constraint.isNotNull(resolver, (String)"EndpointResolver cannot be null");
    }

    public void setBindingDescriptorsLookupStrategy(@Nonnull Function<ProfileRequestContext, List<BindingDescriptor>> strategy) {
        this.checkSetterPreconditions();
        this.bindingDescriptorsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Binding descriptors lookup strategy cannot be null");
    }

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        this.checkSetterPreconditions();
        this.relyingPartyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext lookup strategy cannot be null");
    }

    public void setMetadataContextLookupStrategy(@Nonnull Function<ProfileRequestContext, SAMLMetadataContext> strategy) {
        this.checkSetterPreconditions();
        this.metadataContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SAMLMetadataContext lookup strategy cannot be null");
    }

    public void setBindingContextLookupStrategy(@Nonnull Function<ProfileRequestContext, SAMLBindingContext> strategy) {
        this.checkSetterPreconditions();
        this.bindingContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SAMLBindingContext lookup strategy cannot be null");
    }

    public void setEndpointContextLookupStrategy(@Nonnull Function<ProfileRequestContext, SAMLEndpointContext> strategy) {
        this.checkSetterPreconditions();
        this.endpointContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SAMLEndpointContext lookup strategy cannot be null");
    }

    public void setArtifactContextLookupStrategy(@Nonnull Function<ProfileRequestContext, SAMLArtifactContext> strategy) {
        this.checkSetterPreconditions();
        this.artifactContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SAMLArtifactContext lookup strategy cannot be null");
    }

    public void setBestMatchCriterionLookupStrategy(@Nullable Function<ProfileRequestContext, BestMatchLocationCriterion> strategy) {
        this.checkSetterPreconditions();
        this.bestMatchCriterionLookupStrategy = strategy;
    }

    public void setArtifactImpliesSecureChannel(boolean flag) {
        this.checkSetterPreconditions();
        this.artifactImpliesSecureChannel = flag;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.endpointResolver == null) {
            throw new ComponentInitializationException("EndpointResolver cannot be null");
        }
        QName et = this.endpointType;
        if (et != null) {
            this.endpointBuilder = XMLObjectSupport.getBuilder((QName)et);
            if (this.endpointBuilder == null) {
                throw new ComponentInitializationException("Unable to obtain builder for endpoint type " + String.valueOf(et));
            }
            if (!(this.endpointBuilder.buildObject(et) instanceof Endpoint)) {
                throw new ComponentInitializationException("Builder for endpoint type " + String.valueOf(this.endpointType) + " did not result in Endpoint object");
            }
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        RelyingPartyContext rpContext;
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        MessageContext imc = profileRequestContext.getInboundMessageContext();
        if (imc != null) {
            this.inboundMessage = imc.getMessage();
        }
        if ((rpContext = this.relyingPartyContextLookupStrategy.apply(profileRequestContext)) != null) {
            this.relyingPartyId = rpContext.getRelyingPartyId();
            this.verified = rpContext.isVerified();
            if (rpContext.getProfileConfig() != null && rpContext.getProfileConfig() instanceof SAMLProfileConfiguration) {
                SAMLProfileConfiguration profileConfiguration = (SAMLProfileConfiguration)rpContext.getProfileConfig();
                if (profileConfiguration instanceof SAMLArtifactAwareProfileConfiguration) {
                    this.artifactConfiguration = ((SAMLArtifactAwareProfileConfiguration)profileConfiguration).getArtifactConfiguration(profileRequestContext);
                }
                if (profileConfiguration instanceof BrowserSSOProfileConfiguration) {
                    BrowserSSOProfileConfiguration ssoConfig = (BrowserSSOProfileConfiguration)profileConfiguration;
                    boolean bl = this.skipValidationSinceSigned = this.inboundMessage instanceof AuthnRequest && ssoConfig.isSkipEndpointValidationWhenSigned(profileRequestContext) && !ssoConfig.isIgnoreRequestSignatures(profileRequestContext) && SAMLBindingSupport.isMessageSigned((MessageContext)((MessageContext)Constraint.isNotNull((Object)imc, (String)"No Inboud Message Context")));
                }
            }
        }
        if (profileRequestContext.getOutboundMessageContext() == null) {
            this.log.debug("{} No outbound message context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        this.bindingDescriptors = this.bindingDescriptorsLookupStrategy.apply(profileRequestContext);
        if (this.bindingDescriptors == null) {
            this.bindingDescriptors = CollectionSupport.emptyList();
        }
        this.mdContext = this.metadataContextLookupStrategy.apply(profileRequestContext);
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        RoleDescriptor rdc;
        BestMatchLocationCriterion bestMatch;
        if (this.handleSynchronousRequest(profileRequestContext)) {
            return;
        }
        if (this.endpointType == null) {
            this.log.error("Front-channel binding used, but no endpoint type set");
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"EndpointResolutionFailed");
            return;
        }
        this.log.debug("{} Attempting to resolve endpoint of type {} for outbound message", (Object)this.getLogPrefix(), (Object)this.endpointType);
        ArrayList<String> bindings = new ArrayList<String>(this.bindingDescriptors.size());
        for (BindingDescriptor bindingDescriptor : this.bindingDescriptors) {
            if (!bindingDescriptor.test(profileRequestContext)) continue;
            bindings.add(bindingDescriptor.getId());
        }
        if (bindings.isEmpty()) {
            this.log.warn("{} No outbound bindings are eligible for use", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"EndpointResolutionFailed");
            return;
        }
        this.log.trace("{} Candidate outbound bindings: {}", (Object)this.getLogPrefix(), bindings);
        String firstBinding = (String)bindings.get(0);
        assert (firstBinding != null);
        CriteriaSet criteria = new CriteriaSet(new Criterion[]{new BindingCriterion(bindings), this.buildEndpointCriterion(firstBinding)});
        if (this.bestMatchCriterionLookupStrategy != null && (bestMatch = this.bestMatchCriterionLookupStrategy.apply(profileRequestContext)) != null) {
            criteria.add((Object)bestMatch);
        }
        if ((rdc = this.mdContext != null ? this.mdContext.getRoleDescriptor() : null) != null) {
            criteria.add((Object)new RoleDescriptorCriterion(rdc));
        } else {
            this.log.debug("{} No metadata available for endpoint resolution", (Object)this.getLogPrefix());
        }
        Endpoint resolvedEndpoint = null;
        try {
            resolvedEndpoint = (Endpoint)this.endpointResolver.resolveSingle((Object)criteria);
        }
        catch (ResolverException e) {
            this.log.error("{} Error resolving outbound message endpoint", (Object)this.getLogPrefix(), (Object)e);
        }
        if (resolvedEndpoint == null) {
            this.log.warn("{} Unable to resolve outbound message endpoint for relying party '{}': {}", new Object[]{this.getLogPrefix(), this.relyingPartyId, criteria.get(EndpointCriterion.class)});
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"EndpointResolutionFailed");
            return;
        }
        String bindingURI = resolvedEndpoint.getBinding();
        this.log.debug("{} Resolved endpoint at location {} using binding {}", new Object[]{this.getLogPrefix(), resolvedEndpoint.getLocation(), bindingURI});
        SAMLEndpointContext endpointContext = this.endpointContextLookupStrategy.apply(profileRequestContext);
        endpointContext.setEndpoint(resolvedEndpoint);
        SAMLBindingContext bindingCtx = this.bindingContextLookupStrategy.apply(profileRequestContext);
        MessageContext imc = profileRequestContext.getInboundMessageContext();
        assert (imc != null);
        bindingCtx.setRelayState(SAMLBindingSupport.getRelayState((MessageContext)imc));
        Optional<BindingDescriptor> bindingDescriptor = this.bindingDescriptors.stream().filter(b -> b.ensureId().equals(bindingURI)).findFirst();
        if (bindingDescriptor.isPresent()) {
            bindingCtx.setBindingDescriptor(bindingDescriptor.orElseThrow());
        } else {
            bindingCtx.setBindingUri(resolvedEndpoint.getBinding());
        }
        if (bindingDescriptor.isPresent() && bindingDescriptor.get().isArtifact()) {
            SAMLArtifactConfiguration artifactCfg = this.artifactConfiguration;
            if (artifactCfg != null) {
                SAMLArtifactContext artifactCtx = this.artifactContextLookupStrategy.apply(profileRequestContext);
                artifactCtx.setArtifactType(artifactCfg.getArtifactType());
                artifactCtx.setSourceArtifactResolutionServiceEndpointURL(artifactCfg.getArtifactResolutionServiceURL());
                artifactCtx.setSourceArtifactResolutionServiceEndpointIndex(artifactCfg.getArtifactResolutionServiceIndex());
            }
            if (this.artifactImpliesSecureChannel) {
                this.log.debug("{} Use of artifact binding implies the channel will be secure, overriding MessageChannelSecurityContext flags", (Object)this.getLogPrefix());
                MessageChannelSecurityContext channelCtx = (MessageChannelSecurityContext)profileRequestContext.ensureSubcontext(MessageChannelSecurityContext.class);
                channelCtx.setIntegrityActive(true);
                channelCtx.setConfidentialityActive(true);
            }
        }
    }

    private boolean handleSynchronousRequest(@Nonnull ProfileRequestContext profileRequestContext) {
        if (this.inboundMessage != null) {
            MessageContext imc = profileRequestContext.getInboundMessageContext();
            assert (imc != null);
            SAMLBindingContext bindingCtx = (SAMLBindingContext)imc.getSubcontext(SAMLBindingContext.class);
            if (bindingCtx != null && bindingCtx.getBindingUri() != null) {
                assert (this.bindingDescriptors != null);
                Optional<BindingDescriptor> binding = this.bindingDescriptors.stream().filter(b -> b.ensureId().equals(bindingCtx.getBindingUri())).findFirst();
                if (binding.isPresent() && binding.orElseThrow().isSynchronous()) {
                    this.log.debug("{} Handling request via synchronous binding, preparing outbound binding context for {}", (Object)this.getLogPrefix(), (Object)binding.orElseThrow().getId());
                    SAMLBindingContext outboundCtx = this.bindingContextLookupStrategy.apply(profileRequestContext);
                    outboundCtx.setRelayState(SAMLBindingSupport.getRelayState((MessageContext)imc));
                    outboundCtx.setBindingDescriptor(binding.orElseThrow());
                    return true;
                }
            }
        }
        return false;
    }

    @Nonnull
    private EndpointCriterion<?> buildEndpointCriterion(@Nonnull @NotEmpty String unverifiedBinding) {
        assert (this.endpointType != null);
        Endpoint endpoint = (Endpoint)this.endpointBuilder.buildObject(this.endpointType);
        Object inbound = this.inboundMessage;
        if (inbound instanceof IdPInitiatedSSORequest) {
            this.log.debug("{} Populating template endpoint for resolution from IdP-initiated SSO request", (Object)this.getLogPrefix());
            endpoint.setLocation(((IdPInitiatedSSORequest)inbound).getAssertionConsumerServiceURL());
        } else if (inbound instanceof AuthnRequest) {
            this.log.debug("{} Populating template endpoint for resolution from SAML AuthnRequest", (Object)this.getLogPrefix());
            endpoint.setLocation(((AuthnRequest)inbound).getAssertionConsumerServiceURL());
            endpoint.setBinding(((AuthnRequest)inbound).getProtocolBinding());
            if (endpoint instanceof IndexedEndpoint) {
                ((IndexedEndpoint)endpoint).setIndex(((AuthnRequest)inbound).getAssertionConsumerServiceIndex());
            }
        }
        if (!this.verified) {
            if (endpoint.getBinding() == null) {
                endpoint.setBinding(unverifiedBinding);
                this.log.debug("{} Defaulting binding in \"unverified\" request to {}", (Object)this.getLogPrefix(), (Object)unverifiedBinding);
            }
            return new EndpointCriterion(endpoint, true);
        }
        return new EndpointCriterion(endpoint, this.skipValidationSinceSigned);
    }
}

