/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.nameid.impl;

import jakarta.json.Json;
import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.json.JsonStructure;
import jakarta.json.stream.JsonGenerator;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.slf4j.Logger;

public class TransientIdParameters {
    @Nonnull
    @NotEmpty
    public static final String CONTEXT = "TransientId";
    @Nonnull
    @NotEmpty
    private static final String ATTRIBUTE_RECIPIENT_FIELD = "sp";
    @Nonnull
    @NotEmpty
    private static final String PRINCIPAL_FIELD = "princ";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(TransientIdParameters.class);
    @Nullable
    private final String attributeRecipient;
    @Nullable
    private final String principal;

    public TransientIdParameters(@Nullable String recipient, @Nullable String thePrincipal) {
        this.attributeRecipient = recipient;
        this.principal = thePrincipal;
    }

    public TransientIdParameters(@Nonnull @NotEmpty String encoded) throws IOException {
        Constraint.isNotNull((Object)StringSupport.trimOrNull((String)encoded), (String)"encoded data must not be null or empty");
        JsonReader reader = Json.createReader((Reader)new StringReader(encoded));
        JsonStructure st = reader.read();
        if (!(st instanceof JsonObject)) {
            throw new IOException("Found invalid data structure while parsing IdPSession");
        }
        JsonObject jsonObj = (JsonObject)st;
        this.principal = jsonObj.getString(PRINCIPAL_FIELD);
        this.attributeRecipient = jsonObj.getString(ATTRIBUTE_RECIPIENT_FIELD);
    }

    @Nullable
    public String getAttributeRecipient() {
        return this.attributeRecipient;
    }

    @Nullable
    public String getPrincipal() {
        return this.principal;
    }

    @Nonnull
    public String encode() throws IOException {
        try {
            StringWriter sink = new StringWriter(128);
            JsonGenerator gen = Json.createGenerator((Writer)sink);
            gen.writeStartObject().write(ATTRIBUTE_RECIPIENT_FIELD, this.getAttributeRecipient()).write(PRINCIPAL_FIELD, this.getPrincipal());
            gen.writeEnd().close();
            String result = sink.toString();
            assert (result != null);
            return result;
        }
        catch (JsonException e) {
            this.log.error("Exception while serializing TransientID: {}", (Object)e.getMessage());
            throw new IOException("Exception while serializing TransientID", e);
        }
    }
}

