/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.audit.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml2.core.ArtifactResponse;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.NameIDPolicy;

public class NameIDPolicyFormatAuditExtractor
implements Function<ProfileRequestContext, String> {
    @Nonnull
    private final Function<ProfileRequestContext, SAMLObject> messageLookupStrategy;

    public NameIDPolicyFormatAuditExtractor(@Nonnull Function<ProfileRequestContext, SAMLObject> strategy) {
        this.messageLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Response lookup strategy cannot be null");
    }

    @Override
    @Nullable
    public String apply(@Nullable ProfileRequestContext input) {
        SAMLObject msg = this.messageLookupStrategy.apply(input);
        if (msg != null) {
            NameIDPolicy policy;
            ArtifactResponse ar;
            if (msg instanceof ArtifactResponse) {
                ar = (ArtifactResponse)msg;
                msg = ar.getMessage();
            }
            if (msg instanceof AuthnRequest && (policy = (ar = (AuthnRequest)msg).getNameIDPolicy()) != null) {
                return policy.getFormat();
            }
        }
        return null;
    }
}

