#!/usr/bin/env bash

declare LOCATION
declare IDP_HOME
declare JETTY_HOME
declare JETTY_BASE
declare -a INSTALLED_BASES

LOCATION=$(dirname $0)

# Source our deployer stub.
if [ -e $LOCATION/jettyenv.sh ] ; then
  source $LOCATION/jettyenv.sh
fi

# If JETTY_HOME is defined at this point
# symbolic links are likely not in use.
if [ "${JETTY_BASE}" != "" ] ; then
  echo "JETTY_BASE is already set in the evironment, exiting."
  exit 1
fi

IDP_HOME=$(realpath ${LOCATION}/..)

# Defaults
JETTY_HOME=${JETTY_HOME:-$IDP_HOME/jetty-home}
JETTY_BASE=${JETTY_BASE:-$IDP_HOME/jetty-base}

INSTALLED_BASES=( $( find ${IDP_HOME} -type d -name "jetty-base-*" | sed -e 's/.*base-//' ) )

if [ $# -eq 0 ] ; then
  if [ "${#INSTALLED_BASES[@]}" -eq 0 ] ; then
    # This should only happen if things are manually removed.
    echo "There are no jetty-base versions available, unable to set version"
    exit 1
  elif [ "${#INSTALLED_BASES[@]}" -eq 1 ] ; then
    TARGET_BASE_VER=${INSTALLED_BASES[0]}
  elif [ "${#INSTALLED_BASES[@]}" -gt 1 ] ; then
    echo ""
    echo "Which Jetty Base version would you like to activate?"
    echo ""
    PS3="Your choice => "
    select opt in "${INSTALLED_BASES[@]}"
    do
      TARGET_BASE_VER=$opt
      break
    done
  fi
else
  TARGET_BASE_VER=$1
fi

if [ ! -d "${IDP_HOME}/jetty-base-${TARGET_BASE_VER}" ] ; then
  echo Jetty Base Version ${TARGET_BASE_VER} not found, exiting.
  exit 1
fi

CURRENT_BASE_VER="$(readlink -f ${IDP_HOME}/jetty-base)"
if [ -d "${CURRENT_BASE_VER}" ] ; then
  CURRENT_BASE_VER="$(echo ${CURRENT_BASE_VER} | sed -e 's/.*-//' )"
else
  CURRENT_BASE_VER=""
fi

if [ "${CURRENT_BASE_VER}" == "${TARGET_BASE_VER}" ] ; then
  echo "Jetty Base version ${CURRENT_BASE_VER} is already active."
  exit 0
fi

echo -n "Activating Jetty Base Version ${TARGET_BASE_VER} ... "
ln -snf jetty-base-${TARGET_BASE_VER} ${IDP_HOME}/jetty-base
echo "Done."
