#!/usr/bin/env bash

declare JAVACMD
declare LOCATION
declare IDP_HOME
declare JETTY_HOME
declare JETTY_BASE

declare JVM_ARGS
declare JETTY_ARGS
declare JETTY_TMP

LOCATION=$(dirname $0)

# Source our deployer stub.
if [ -e $LOCATION/jettyenv.sh ] ; then
  source $LOCATION/jettyenv.sh
fi

if [ -z "$JAVACMD" ] ; then
  if [ -n "$JAVA_HOME"  ] ; then
    JAVACMD=$JAVA_HOME/bin/java
  else
    JAVACMD=$(which java)
  fi
fi

if [ ! -x "$JAVACMD" ] ; then
  echo "Error: JAVA_HOME is not defined correctly."
  echo "  We cannot execute $JAVACMD"
  exit 1
fi

IDP_HOME=$(realpath ${LOCATION}/..)

JETTY_HOME=${JETTY_HOME:-$IDP_HOME/jetty-home}
if [ ! -e "$JETTY_HOME/start.jar" ] ; then
  echo "Error: JETTY_HOME is not defined correctly."
  echo " $JETTY_HOME/start.jar not found"
  exit 1
fi

JETTY_BASE=${JETTY_BASE:-$IDP_HOME/jetty-base}
if [ ! -d "$JETTY_BASE/start.d" ] ; then
  echo "Error: JETTY_BASE is not defined correctly."
  echo " $JETTY_BASE/start.d not found"
  exit 1
fi

JETTY_TMP=$IDP_HOME/jetty-dist/jetty-tmp
if [ ! -e "$JETTY_TMP" ] ; then
  echo "Creating $JETTY_TMP"
  mkdir "$JETTY_TMP"
fi

JVM_ARGS="-Didp.home=$IDP_HOME -Djava.io.tmpdir=$JETTY_TMP -XX:+UseG1GC"

JETTY_ARGS="jetty.base=$JETTY_BASE jetty.logging.dir=$IDP_HOME/logs --exec"

success() {
    [ "$BOOTUP" = "color" ] && $MOVE_TO_COL
    echo -n "["
    [ "$BOOTUP" = "color" ] && $SETCOLOR_SUCCESS
    echo -n $"  OK  "
    [ "$BOOTUP" = "color" ] && $SETCOLOR_NORMAL
    echo -n "]"
    echo -ne "\r"
    return 0
}

failure() {
    [ "$BOOTUP" = "color" ] && $MOVE_TO_COL
    echo -n "["
    [ "$BOOTUP" = "color" ] && $SETCOLOR_FAILURE
    echo -n $"FAILED"
    [ "$BOOTUP" = "color" ] && $SETCOLOR_NORMAL
    echo -n "]"
    echo -ne "\r"
    return 1
}

getpid() {
    ps ax -w -w | grep "$JETTY_HOME" | grep "\--exec" | awk '{printf $1 " "}'
}

run() {
    $JAVACMD $JAVA_OPTS '-jar' $JETTY_HOME/start.jar $JVM_ARGS $JETTY_ARGS "$@"
}

start() {
    $JAVACMD $JAVA_OPTS '-jar' $JETTY_HOME/start.jar $JVM_ARGS $JETTY_ARGS "$@" &

    PID=`getpid`
    if [ -z "$PID" ] ; then
        failure
    else
        success
    fi
    echo
}

stop() {
    echo -n $"Shutting down Jetty: "
    PID=`getpid`
    if [ -z "$PID" ] ; then
        failure
    else
        kill $PID && success || failure
    fi
    echo
}

status() {
    getpid | wc | awk '{print $2}' > /tmp/jetty_process_count.txt
    read line < /tmp/jetty_process_count.txt
    if [ $line -gt 0 ]; then
        echo -n "Jetty ( pid "
        echo -n `getpid`
        echo -n ") is running..."
        echo
    else
        echo "Jetty is stopped"
    fi
}

case "$1" in
    run)
        run
        ;;
    start)
        start
        ;;
    stop)
        stop
        ;;
    restart)
        stop
        sleep 3
        start
        ;;
    status)
        status
        ;;
    *)
        run
        exit 0
esac

