#!/usr/bin/env bash
declare LOCATION
declare CLASSPATH
declare VERSION

LOCATION=$(dirname $0)
CLASSPATH=$LOCATION/net.shibboleth.idp.jetty-base/jetty-cli.jar
export CLASSPATH

VERSION=""
if [ "$#" -ge "1" -a "${1:0:1}" != "-" ] ; then
    VERSION="$1"
    shift
elif [ "$#" -eq "0" ] ; then
    while [ -z "$VERSION" ] ; do
        read -p "Jetty version to download: " VERSION
    done
fi

if [ -e "$LOCATION/../jetty-dist/jetty-home-$VERSION.tar.gz" ] ; then
  echo "Error: $LOCATION/../jetty-dist/jetty-home-$VERSION.tar.gz already exists"
  exit 1
fi

if [ -e "$LOCATION/../jetty-dist/jetty-home-$VERSION" ] ; then
  echo "Error: $LOCATION/../jetty-dist/jetty-home-$VERSION already exists"
  exit 1
fi


$LOCATION/runclass.sh -Dnet.shibboleth.idp.cli.arguments=net.shibboleth.idp.plugin.jetty.cli.impl.JettyDownloadArugments net.shibboleth.idp.plugin.jetty.cli.impl.JettyDownloadCLI --home "$LOCATION/.." -v "${VERSION}" "$@"
