/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.idp.plugin.jetty;

import java.io.IOException;
import java.util.Set;

import net.shibboleth.idp.module.IdPModule;
import net.shibboleth.idp.module.jetty.JettyModule;
import net.shibboleth.idp.plugin.impl.FirstPartyIdPPlugin;
import net.shibboleth.profile.module.ModuleException;
import net.shibboleth.profile.plugin.PluginException;
import net.shibboleth.shared.collection.CollectionSupport;

/**Details about the Jetty plugin.  */
public class JettyPlugin extends FirstPartyIdPPlugin {
    /** Constructor.
     * @throws PluginException from {@link FirstPartyIdPPlugin}
     * @throws IOException from {@link FirstPartyIdPPlugin}
     */
    public JettyPlugin() throws PluginException, IOException {
        super(JettyPlugin.class);
        try {
            final Set<IdPModule> modules = CollectionSupport.singleton(new JettyModule());
            setEnableOnInstall(modules);
            setDisableOnRemoval(modules);
        } catch (final IOException e) {
            throw e;
        } catch (final ModuleException e) {
            throw new PluginException(e);
        }
    }
}
