#!/usr/bin/env bash

declare LOCATION
declare IDP_HOME
declare JETTY_HOME
declare JETTY_BASE
declare -a INSTALLED_JETTYS

LOCATION=$(dirname $0)

# Source our deployer stub.
if [ -e $LOCATION/jettyenv.sh ] ; then
  source $LOCATION/jettyenv.sh
fi

# If JETTY_HOME is defined at this point
# symbolic links are likely not in use.
if [ "${JETTY_HOME}" != "" ] ; then
  echo "JETTY_HOME is already set in the evironment, exiting."
  exit 1
fi

IDP_HOME=$(realpath ${LOCATION}/..)

# Defaults
JETTY_HOME=${JETTY_HOME:-$IDP_HOME/jetty-home}
JETTY_BASE=${JETTY_BASE:-$IDP_HOME/jetty-base}

INSTALLED_JETTYS=( $( find ${IDP_HOME} -type d -name "jetty-home-*" | sed -e 's/.*home-//' ) )

if [ $# -eq 0 ] ; then
  if [ "${#INSTALLED_JETTYS[@]}" -eq 0 ] ; then
    echo "Jetty has not been downloaded, unable to set version"
    exit 1
  elif [ "${#INSTALLED_JETTYS[@]}" -eq 1 ] ; then
    TARGET_JETTY_VER=${INSTALLED_JETTYS[0]}
  elif [ "${#INSTALLED_JETTYS[@]}" -gt 1 ] ; then
    echo ""
    echo "Which Jetty version would you like to activate?"
    echo ""
    PS3="Your choice => "
    select opt in "${INSTALLED_JETTYS[@]}"
    do
      TARGET_JETTY_VER=$opt
      break
    done
  fi
else
  TARGET_JETTY_VER=$1
fi

if [ ! -d "${IDP_HOME}/jetty-dist/jetty-home-${TARGET_JETTY_VER}" ] ; then
  echo Jetty Version ${TARGET_JETTY_VER} not found, exiting.
  exit 1
fi

CURRENT_JETTY_VER="$(readlink -f ${IDP_HOME}/jetty-home)"
if [ -d "${CURRENT_JETTY_VER}" ] ; then
  CURRENT_JETTY_VER="$(echo $CURRENT_JETTY_VER | sed -e 's/.*-//')"
else
  CURRENT_JETTY_VER=""
fi

if [ "${CURRENT_JETTY_VER}" == "${TARGET_JETTY_VER}" ] ; then
  echo "Jetty version ${CURRENT_JETTY_VER} is already active."
  exit 0
fi

echo -n "Activating Jetty Version ${TARGET_JETTY_VER} ... "
ln -snf jetty-dist/jetty-home-${TARGET_JETTY_VER} ${IDP_HOME}/jetty-home
echo "Done."
