@echo off

set SAVE_WORKING_DIR_SET_JETTYBASE=%cd%
cd /d %~dp0..
set IDP_HOME_WINDOWS=%cd%
cd /d %SAVE_WORKING_DIR_SET_JETTYBASE%
set SAVE_WORKING_DIR_SET_JETTYBASE=

if not exist %IDP_HOME_WINDOWS%\jetty-base-%1% (
   echo Error: jetty-base-%1% not installed
   exit /b
)

set JETTY_BASE=%IDP_HOME_WINDOWS%\jetty-base-%1%
setx /m JETTY_BASE %JETTY_BASE%
echo JETTY_BASE set to be %JETTY_BASE%

sc qc shibd_idp > nul 2>&1

REM below reads if error level > 1 then ....
if errorlevel 1 (
   echo Procrun not installed, skipping further configuration
   exit /b
)

REM
REM we do no want any of these variables polluting the environment
REM
setlocal
set IDP_HOME_UNIX=%IDP_HOME_WINDOWS:\=/%
set JETTY_TMP=%IDP_HOME_WINDOWS%\jetty-dist\jetty-tmp
set PRUNSRV=%PROCRUN_HOME%\amd64\prunsrv.exe

if not exist %PRUNSRV% (
   echo Error: %PRUNSRV% not found.  Corrupt install
   exit /b
)
REM
REM As per config-jetty we will set the shibd_idp parameters according to 
REM https://commons.apache.org/proper/commons-daemon/procrun.html
REM
REM Annoyingly, the PR_xxx trick always appends so we run //US twice
REM Once to set the first parameter via the --Option thing and then
REM a second time to append the rest of the stuff.
REM
REM Make sure there are no parameters set (otherwise they will be appended
REM to our exiting settings).
REM
SET PR_DESCRIPTION=
SET PR_DISPLAYNAME=
SET PR_INSTALL=
SET PR_STARTUP=
SET PR_TYPE=
SET PR_DEPENDSON=
SET PR_ENVIRONMENT=
SET PR_USER=
SET PR_PASSWORD=
SET PR_SERVICEUSER=
SET PR_SERVICEPASSWORD=
SET PR_LIBRARYPATH=
SET PR_JAVAHOME=
SET PR_JVM=
SET PR_JVMOPTIONS=
SET PR_JVMOPTIONS9=
SET PR_CLASSPATH=
SET PR_JVMMS=
SET PR_JVMMX=
SET PR_JVMSS=
SET PR_STARTMODE=
SET PR_STARTIMAGE=
SET PR_STARTPATH=
SET PR_STARTCLASS=
SET PR_STARTMETHOD=
SET PR_STARTPARAMS=
SET PR_STOPMODE=
SET PR_STOPIMAGE=
SET PR_STOPPATH=
SET PR_STOPCLASS=
SET PR_STOPMETHOD=
SET PR_STOPPARAMS=
SET PR_STOPTIMEOUT=
SET PR_LOGPATH=
SET PR_LOGPREFIX=
SET PR_LOGLEVEL=
SET PR_LOGJNIMESSAGES=
SET PR_STDOUTPUT=
SET PR_STDERROR=
SET PR_PIDFILE=

REM
REM Force a reset of the three things we want to change
REM
%PRUNSRV%  //US/Shibd_idp --JvmOptions=-Didp.home=%IDP_HOME_UNIX% --StartParams=STOP_PORT=8963 --StopParams=--stop;STOP_PORT=8963

REM
REM And set up the rest to be appended
REM
SET PORTPASS=%random%-%random%-%random%-%random%
SET PR_JVMOPTIONS=-Djava.io.tmpdir=%JETTY_TMP%;-Dlogback.configurationFile=%JETTY_BASE%\resources\logback.xml;-XX:+UseG1GC
SET PR_STARTPARAMS=STOP.KEY=%PORTPASS%;jetty.base=%JETTY_BASE%;jetty.logging.dir=%IDP_HOME_WINDOWS%\logs
SET PR_STOPPARAMS=%PR_STARTPARAMS%

%PRUNSRV%  //US/Shibd_idp

echo Restart shibd_idp to start using this version

