/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.module.jetty;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import net.shibboleth.idp.Version;
import net.shibboleth.idp.module.impl.PluginIdPModule;
import net.shibboleth.profile.module.Module;
import net.shibboleth.profile.module.ModuleContext;
import net.shibboleth.profile.module.ModuleException;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.security.impl.SelfSignedCertificateGenerator;
import org.slf4j.Logger;

public class JettyModule
extends PluginIdPModule {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(JettyModule.class);

    public JettyModule() throws IOException, ModuleException {
        super(Version.getVersion(), JettyModule.class);
    }

    @Nonnull
    public Map<Module.ModuleResource, Module.ResourceResult> enable(@Nonnull ModuleContext moduleContext) throws ModuleException {
        Map result = super.enable(moduleContext);
        Path idpHome = Path.of(moduleContext.getInstallLocation(), new String[0]);
        Path keystore = idpHome.resolve("credentials").resolve("idp-userfacing.p12");
        if (!Files.exists(keystore, new LinkOption[0])) {
            this.generateKeystore(keystore, idpHome.resolve("credentials").resolve("idp-userfacing.crt"));
        }
        this.handleLogbackJars(idpHome, "jetty-base-12");
        return result;
    }

    private void handleLogbackJars(@Nonnull Path idpHome, @Nonnull @NotEmpty String jettyBaseName) throws ModuleException {
        Path jettyBaseDir = idpHome.resolve(jettyBaseName);
        Path jarTargetDir = jettyBaseDir.resolve("lib").resolve("logging");
        try {
            this.log.debug("Creating {}", (Object)jarTargetDir);
            Files.createDirectories(jarTargetDir, new FileAttribute[0]);
            Path distLibDir = idpHome.resolve("dist").resolve("webapp").resolve("WEB-INF").resolve("lib");
            String version = this.inferLogbackVersion(distLibDir);
            this.copyLogbackJar(distLibDir, jarTargetDir, "logback-classic-" + version + ".jar");
            this.copyLogbackJar(distLibDir, jarTargetDir, "logback-core-" + version + ".jar");
            this.log.debug("Writing logback ini");
            try (PrintStream out = new PrintStream(jettyBaseDir.resolve("start.d").resolve("logback.ini").toFile());){
                out.format("--module=logging-logback\n\nlogback.version=%s\n", version);
            }
        }
        catch (IOException ex) {
            this.log.error("Could not set up logback environment {}", (Throwable)ex);
            throw new ModuleException((Exception)ex);
        }
    }

    private void copyLogbackJar(@Nonnull Path sourceDir, @Nonnull Path targetDir, @Nonnull @NotEmpty String jarName) throws IOException {
        File targetFile = targetDir.resolve(jarName).toFile();
        if (targetFile.exists()) {
            this.log.debug("Logback jar {} already exists.", (Object)targetFile);
            return;
        }
        File sourceFile = sourceDir.resolve(jarName).toFile();
        if (!sourceFile.exists()) {
            this.log.error("Logback jar {} does not exist.", (Object)sourceFile);
            throw new IOException("Logback jar not found");
        }
        this.log.debug("Copying {} to {}", (Object)sourceFile, (Object)targetFile);
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(sourceFile));
             BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(targetFile));){
            ((InputStream)in).transferTo(out);
        }
    }

    private String inferLogbackVersion(@Nonnull Path distLibDir) throws ModuleException {
        String string;
        block9: {
            DirectoryStream<Path> stream = Files.newDirectoryStream(distLibDir, "logback-classic-*.jar");
            try {
                Iterator<Path> i = stream.iterator();
                if (!i.hasNext()) {
                    this.log.error("Could not locate logback-classic-*.jar in {}", (Object)distLibDir);
                    throw new ModuleException("Could not locate logback jars ");
                }
                String fileName = i.next().getFileName().toString();
                int len = fileName.length();
                string = fileName.substring(16, len - 4);
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    this.log.error("Error looking for logback-classic-*.jar in {}", (Object)distLibDir, (Object)ex);
                    throw new ModuleException((Exception)ex);
                }
            }
            stream.close();
        }
        return string;
    }

    private void generateKeystore(@Nonnull Path keyStore, @Nonnull Path crtFile) throws ModuleException {
        SelfSignedCertificateGenerator generator = new SelfSignedCertificateGenerator();
        generator.setKeystoreFile(keyStore.toFile());
        generator.setCertificateFile(crtFile.toFile());
        generator.setKeySize(3072);
        String hostName = this.getBestHostName();
        generator.setHostName(hostName);
        String altName = "https://" + hostName + "/idp/shibboleth";
        generator.setURISubjectAltNames((Collection)CollectionSupport.singletonList((Object)altName));
        generator.setKeystorePassword("changeit");
        this.log.info("Creating {}, CN = {} URI = {}, keySize={}", new Object[]{keyStore, hostName, altName, 3072});
        try {
            generator.generate();
        }
        catch (Exception e) {
            this.log.error("Error building keystore andcrt files {}", (Object)keyStore, (Object)e);
            throw new ModuleException("Error Key Store", e);
        }
    }

    private boolean hasHostName(@Nonnull InetAddress addr) {
        return !addr.getHostAddress().equals(addr.getCanonicalHostName());
    }

    @Nonnull
    public String getBestHostName() {
        InetAddress bestSoFar = null;
        try {
            for (NetworkInterface netInterface : Collections.list(NetworkInterface.getNetworkInterfaces())) {
                for (InetAddress address : Collections.list(netInterface.getInetAddresses())) {
                    if (bestSoFar == null) {
                        bestSoFar = address;
                        continue;
                    }
                    if (address == null || address.isLoopbackAddress()) continue;
                    if (address.isLinkLocalAddress()) {
                        if (!bestSoFar.isLoopbackAddress()) continue;
                        bestSoFar = address;
                        continue;
                    }
                    if (address.isSiteLocalAddress()) {
                        if (!bestSoFar.isLoopbackAddress() && !bestSoFar.isLinkLocalAddress() && (!bestSoFar.isSiteLocalAddress() || this.hasHostName(bestSoFar))) continue;
                        bestSoFar = address;
                        continue;
                    }
                    if (!bestSoFar.isLoopbackAddress() && !bestSoFar.isLinkLocalAddress() && !bestSoFar.isSiteLocalAddress() && this.hasHostName(bestSoFar)) continue;
                    bestSoFar = address;
                }
            }
        }
        catch (SocketException e) {
            this.log.error("Could not get host information", (Throwable)e);
        }
        if (bestSoFar == null) {
            return "localhost.localdomain";
        }
        String result = bestSoFar.getCanonicalHostName();
        assert (result != null);
        return result;
    }
}

