/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.webauthn.storage.impl;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.sql.DataSource;
import net.shibboleth.idp.plugin.authn.webauthn.storage.impl.WebAuthnJDBCQueryAccelerator;
import net.shibboleth.idp.plugin.authn.webauthn.storage.impl.WebAuthnJDBCReadAllAccelerator;
import net.shibboleth.idp.plugin.authn.webauthn.storage.impl.WebAuthnJDBCStorageRecord;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Positive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.ConstraintViolationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.storage.StorageRecord;
import org.slf4j.Logger;

public final class WebAuthnJDBCAcceleratorImpl
extends AbstractIdentifiableInitializableComponent
implements WebAuthnJDBCQueryAccelerator,
WebAuthnJDBCReadAllAccelerator {
    static final String DEFAULT_QUERY_BY_USERHANDLE_RECORD_SQL = "SELECT version, expires, value FROM StorageRecords,  JSON_TABLE(value,'$[*]' COLUMNS (uid text PATH '$.userIdentity.id')) AS cred WHERE context=? AND cred.uid=?";
    static final String DEFAULT_QUERY_BY_CREDENTIALID_RECORD_SQL = "SELECT version, expires, value FROM StorageRecords,  JSON_TABLE(value,'$[*]' COLUMNS (cid text PATH '$.credential.credentialId')) AS cred WHERE context=? AND cred.cid=?";
    static final String DEFAULT_READ_ALL_BY_CONTEXT_SQL = "SELECT version, expires, value FROM StorageRecords WHERE context=?";
    static final Duration DEFAULT_QUERY_TIMEOUT = Duration.ofSeconds(5L);
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(WebAuthnJDBCAcceleratorImpl.class);
    private int transactionRetries = 3;
    private ReadWriteLock readWriteLock;
    @Nonnull
    @NonnullElements
    private Collection<String> retryableErrors = CollectionSupport.emptyList();
    @NonnullAfterInit
    private DataSource dataSource;
    private int transactionIsolation = 8;
    @Nonnull
    private final Duration queryTimeout;
    @Nonnull
    @NotEmpty
    private String queryRecordsByUserHandleSQL = "SELECT version, expires, value FROM StorageRecords,  JSON_TABLE(value,'$[*]' COLUMNS (uid text PATH '$.userIdentity.id')) AS cred WHERE context=? AND cred.uid=?";
    @Nonnull
    @NotEmpty
    private String queryRecordsByCredentialIdSQL = "SELECT version, expires, value FROM StorageRecords,  JSON_TABLE(value,'$[*]' COLUMNS (cid text PATH '$.credential.credentialId')) AS cred WHERE context=? AND cred.cid=?";
    @Nonnull
    @NotEmpty
    private String readAllByContextSQL = "SELECT version, expires, value FROM StorageRecords WHERE context=?";

    public WebAuthnJDBCAcceleratorImpl() {
        assert (DEFAULT_QUERY_TIMEOUT != null);
        this.queryTimeout = DEFAULT_QUERY_TIMEOUT;
    }

    public void setLocalLocking(boolean what) {
        this.readWriteLock = what ? new ReentrantReadWriteLock(true) : null;
    }

    public void setRetryableErrors(@Nonnull @NonnullElements List<String> errors) {
        this.retryableErrors = CollectionSupport.copyToList((Collection)((Collection)Constraint.isNotNull(errors, (String)"errors must not be null")));
        Constraint.noNullItems(errors, (String)"errors must not have null members");
    }

    public void setTransactionRetries(@Positive int count) {
        this.transactionRetries = count;
        if (count < 0) {
            throw new ConstraintViolationException("transaction retry must be positive");
        }
    }

    protected int getTransactionRetries() {
        return this.transactionRetries;
    }

    public void setTransactionIsolation(int what) {
        this.transactionIsolation = what;
    }

    public void setQueryRecordsByUserHandleSQL(String what) {
        this.queryRecordsByUserHandleSQL = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)what), (String)"ReadRecordsByUserHandleSQL should be non-null and non empty");
    }

    public void setQueryRecordsByCredentialIdSQL(String what) {
        this.queryRecordsByCredentialIdSQL = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)what), (String)"ReadRecordsByCredentialIdSQL should be non-null and non empty");
    }

    public void setReadAllByContextSQL(@Nonnull @NotEmpty String what) {
        this.readAllByContextSQL = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)what), (String)"Read All By Context SQL should be non-null and non empty");
    }

    public void setDataSource(@Nonnull DataSource source) {
        this.dataSource = (DataSource)Constraint.isNotNull((Object)source, (String)"DataSource should be non null");
    }

    @Override
    @Unmodifiable
    @NonnullElements
    @NotLive
    public <T> List<StorageRecord<Set<T>>> queryByUserHandle(String context, String userHandle) throws IOException {
        return CollectionSupport.copyToList(this.query(this.queryRecordsByUserHandleSQL, new String[]{context, userHandle}));
    }

    @Override
    @Unmodifiable
    @NonnullElements
    @NotLive
    public <T> List<StorageRecord<Set<T>>> queryByCredentialId(String context, String credentialId) throws IOException {
        return CollectionSupport.copyToList(this.query(this.queryRecordsByCredentialIdSQL, new String[]{context, credentialId}));
    }

    @Override
    @Nonnull
    @NonnullElements
    @NotLive
    public <T> List<StorageRecord<T>> readAll(@Nonnull @NotEmpty String context) throws IOException {
        return CollectionSupport.copyToList(this.query(this.readAllByContextSQL, new String[]{context}));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nonnull
    private <T> List<StorageRecord<T>> query(@Nonnull @NotEmpty String sql, @Nullable @NonnullElements String[] parameters) throws IOException {
        Constraint.isNotEmpty((String)((String)Constraint.isNotNull((Object)sql, (String)"query: sql must not be null")), (String)"read: context must not be empty");
        int retries = this.transactionRetries;
        while (true) {
            Object resultSet2;
            ConnectionWithLock connection;
            block26: {
                connection = new ConnectionWithLock(true, false);
                PreparedStatement stmnt2 = connection.prepareStatement(sql);
                try {
                    this.log.trace("Read:: '{}' parameters: '{}'", (Object)sql, (Object)parameters);
                    if (parameters != null) {
                        for (int i = 0; i < parameters.length; ++i) {
                            stmnt2.setString(i + 1, parameters[i]);
                        }
                    }
                    ArrayList results = new ArrayList();
                    resultSet2 = stmnt2.executeQuery();
                    try {
                        while (resultSet2.next()) {
                            Long returnedVersion = resultSet2.getLong(1);
                            Long returnedExpires = WebAuthnJDBCAcceleratorImpl.getExpires((ResultSet)resultSet2, 2);
                            String returnedValue = (String)Constraint.isNotNull((Object)resultSet2.getString(3), (String)"value field must not be null");
                            if (returnedExpires != null && System.currentTimeMillis() >= returnedExpires) {
                                this.log.debug("Record '{}' expired at '{}', omitting", (Object)returnedValue, (Object)returnedExpires);
                                continue;
                            }
                            WebAuthnJDBCStorageRecord result = new WebAuthnJDBCStorageRecord(returnedValue, returnedExpires, returnedVersion);
                            results.add(result);
                        }
                    }
                    finally {
                        if (resultSet2 != null) {
                            resultSet2.close();
                        }
                    }
                    resultSet2 = results;
                    if (stmnt2 == null) break block26;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            if (stmnt2 == null) throw throwable;
                            try {
                                stmnt2.close();
                                throw throwable;
                            }
                            catch (Throwable resultSet2) {
                                throwable.addSuppressed(resultSet2);
                            }
                            throw throwable;
                        }
                        catch (Throwable stmnt2) {
                            try {
                                connection.close();
                                throw stmnt2;
                            }
                            catch (Throwable throwable2) {
                                stmnt2.addSuppressed(throwable2);
                            }
                            throw stmnt2;
                        }
                    }
                    catch (SQLException e) {
                        boolean retry = false;
                        for (String msg : this.retryableErrors) {
                            if (e.getSQLState() == null || !e.getSQLState().contains(msg)) continue;
                            this.log.warn("Caught retryable SQL exception", (Throwable)e);
                            retry = true;
                            break;
                        }
                        if (!retry) throw new IOException(e);
                        if (--retries < 0) {
                            this.log.warn("Error retryable, but retry limit exceeded");
                            throw new IOException(e);
                        }
                        this.log.info("Retrying JDBC Read operation");
                    }
                }
                stmnt2.close();
            }
            connection.close();
            return resultSet2;
        }
    }

    @Nullable
    protected static Long getExpires(@Nonnull ResultSet results, int columm) throws SQLException {
        long value = results.getLong(columm);
        if (results.wasNull()) {
            return null;
        }
        return value;
    }

    protected class ConnectionWithLock
    implements AutoCloseable {
        @Nonnull
        private final Connection connection;
        @Nullable
        private final Lock threadLock;
        private final boolean isAutoCommit;
        private boolean isCommited;
        private boolean isRolledBack;

        public ConnectionWithLock(boolean autoCommit, boolean writeLock) throws SQLException {
            Connection con = WebAuthnJDBCAcceleratorImpl.this.dataSource.getConnection();
            assert (con != null);
            this.connection = con;
            this.isAutoCommit = autoCommit;
            this.connection.setAutoCommit(autoCommit);
            if (WebAuthnJDBCAcceleratorImpl.this.transactionIsolation > 0) {
                this.connection.setTransactionIsolation(WebAuthnJDBCAcceleratorImpl.this.transactionIsolation);
            }
            if (WebAuthnJDBCAcceleratorImpl.this.readWriteLock != null) {
                this.threadLock = writeLock ? WebAuthnJDBCAcceleratorImpl.this.readWriteLock.writeLock() : WebAuthnJDBCAcceleratorImpl.this.readWriteLock.readLock();
                assert (this.threadLock != null);
                this.threadLock.lock();
            } else {
                this.threadLock = null;
            }
        }

        public PreparedStatement prepareStatement(String sql) throws SQLException {
            PreparedStatement statement = this.connection.prepareStatement(sql);
            statement.setQueryTimeout((int)WebAuthnJDBCAcceleratorImpl.this.queryTimeout.toSeconds());
            return statement;
        }

        public void commit() throws SQLException {
            assert (!(this.isAutoCommit || this.isCommited || this.isRolledBack));
            this.isCommited = true;
            this.connection.commit();
        }

        public void rollback() throws SQLException {
            assert (!(this.isAutoCommit || this.isCommited || this.isRolledBack));
            this.isRolledBack = true;
            this.connection.rollback();
        }

        @Override
        public void close() {
            assert (this.isAutoCommit || this.isCommited || this.isRolledBack);
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                WebAuthnJDBCAcceleratorImpl.this.log.error("Auto close failed", (Throwable)e);
            }
            if (this.threadLock != null) {
                this.threadLock.unlock();
            }
        }
    }
}

