/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.webauthn.storage.impl;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.authn.webauthn.exception.CredentialRepositoryException;
import net.shibboleth.idp.plugin.authn.webauthn.storage.CredentialRecord;
import net.shibboleth.idp.plugin.authn.webauthn.storage.impl.WebAuthnJDBCReadAllAccelerator;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.storage.StorageRecord;
import org.slf4j.Logger;

public class ReadAllCacheLoadingStrategy
implements Function<String, List<StorageRecord<Set<CredentialRecord>>>> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ReadAllCacheLoadingStrategy.class);
    @Nonnull
    private final WebAuthnJDBCReadAllAccelerator queryAccelerator;

    public ReadAllCacheLoadingStrategy(@Nonnull WebAuthnJDBCReadAllAccelerator accelerator) {
        this.queryAccelerator = (WebAuthnJDBCReadAllAccelerator)Constraint.isNotNull((Object)accelerator, (String)"Accelerator can not be empty");
    }

    @Override
    public List<StorageRecord<Set<CredentialRecord>>> apply(String storageContext) {
        if (storageContext == null) {
            throw new CredentialRepositoryException("Query parameters can not be null");
        }
        try {
            List<StorageRecord<Set<CredentialRecord>>> records = this.queryAccelerator.readAll(storageContext);
            this.log.trace("ReadAll cache loading strategy has read '{}' record(s)", (Object)records.size());
            return records;
        }
        catch (IOException e) {
            throw new CredentialRepositoryException((Exception)e);
        }
    }
}

