/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.webauthn.storage.impl;

import com.yubico.webauthn.data.ByteArray;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.authn.webauthn.exception.CredentialRepositoryException;
import net.shibboleth.idp.plugin.authn.webauthn.storage.CredentialRecord;
import net.shibboleth.idp.plugin.authn.webauthn.storage.impl.WebAuthnJDBCQueryAccelerator;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.storage.StorageRecord;

public class QueryByUserHandleStrategy
implements BiFunction<String, ByteArray, List<StorageRecord<Set<CredentialRecord>>>> {
    @Nonnull
    private final WebAuthnJDBCQueryAccelerator queryAccelerator;

    public QueryByUserHandleStrategy(@Nonnull WebAuthnJDBCQueryAccelerator accelerator) {
        this.queryAccelerator = (WebAuthnJDBCQueryAccelerator)Constraint.isNotNull((Object)accelerator, (String)"Accelerator can not be empty");
    }

    @Override
    public List<StorageRecord<Set<CredentialRecord>>> apply(String storageContext, ByteArray userHandle) {
        if (storageContext == null || userHandle == null) {
            throw new CredentialRepositoryException("Query parameters can not be null");
        }
        String userHandleB64 = userHandle.getBase64Url();
        try {
            return this.queryAccelerator.queryByUserHandle(storageContext, userHandleB64);
        }
        catch (IOException e) {
            throw new CredentialRepositoryException((Exception)e);
        }
    }
}

