/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.webauthn.storage.impl;

import com.google.common.cache.Cache;
import com.yubico.webauthn.data.ByteArray;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.authn.webauthn.storage.CredentialRecord;
import net.shibboleth.idp.plugin.authn.webauthn.storage.impl.CacheService;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

public final class CacheServiceImpl
implements CacheService {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(CacheServiceImpl.class);
    @Nonnull
    private final Cache<String, String> cache;
    @Nonnull
    private final Function<CredentialRecord, String> keyExtractionStrategy;
    @Nonnull
    private final Function<ByteArray, String> lookupKeyExtractionStrategy;
    @Nonnull
    private final Function<CredentialRecord, String> valueExtractionStrategy;

    private CacheServiceImpl(Builder builder) {
        this.cache = (Cache)Constraint.isNotNull(builder.cacheBuild, (String)"Cache can not be null");
        this.keyExtractionStrategy = (Function)Constraint.isNotNull(builder.keyExtractionStrategyBuild, (String)"Key extraction strategy can not be null");
        this.lookupKeyExtractionStrategy = (Function)Constraint.isNotNull(builder.lookupKeyExtractionStrategyBuild, (String)"Lookup key extraction strategy can not be null");
        this.valueExtractionStrategy = (Function)Constraint.isNotNull(builder.valueExtractionStrategyBuild, (String)"Value extraction strategy can not be null");
    }

    protected Cache<String, String> getCache() {
        return this.cache;
    }

    @Override
    public String getIfPresent(@Nonnull ByteArray keyBytes) {
        String key = this.lookupKeyExtractionStrategy.apply(keyBytes);
        String username = (String)this.cache.getIfPresent((Object)key);
        this.log.trace("{} for key '{}'", (Object)(username != null ? "CacheHit::" : "CacheMiss::"), (Object)key);
        return username;
    }

    @Override
    public void put(@Nonnull CredentialRecord registration) {
        String key = this.keyExtractionStrategy.apply(registration);
        String value = this.valueExtractionStrategy.apply(registration);
        this.log.trace("CachePut:: key '{}', value '{}'", (Object)key, (Object)value);
        this.cache.put((Object)key, (Object)value);
    }

    @Override
    public void invalidate(@Nonnull ByteArray key) {
        String lookupKey = this.lookupKeyExtractionStrategy.apply(key);
        this.log.trace("CacheRemove:: key '{}'", (Object)lookupKey);
        this.cache.invalidate((Object)lookupKey);
    }

    @Override
    public void invalidateAll() {
        this.cache.invalidateAll();
    }

    public static IUserHandleMappingCacheStage builder() {
        return new Builder();
    }

    public static final class Builder
    implements IUserHandleMappingCacheStage,
    IBuildStage {
        @Nullable
        private Cache<String, String> cacheBuild;
        private Function<CredentialRecord, String> keyExtractionStrategyBuild;
        private Function<ByteArray, String> lookupKeyExtractionStrategyBuild;
        private Function<CredentialRecord, String> valueExtractionStrategyBuild;

        private Builder() {
        }

        @Override
        public IBuildStage withCache(@Nonnull Cache<String, String> cache) {
            this.cacheBuild = (Cache)Constraint.isNotNull(cache, (String)"User handle mapping cache can not be null");
            return this;
        }

        @Override
        public IBuildStage withKeyExtractionStrategy(Function<CredentialRecord, String> keyExtractionStrategy) {
            this.keyExtractionStrategyBuild = keyExtractionStrategy;
            return this;
        }

        @Override
        public IBuildStage withLookupKeyExtractionStrategy(Function<ByteArray, String> lookupKeyExtractionStrategy) {
            this.lookupKeyExtractionStrategyBuild = lookupKeyExtractionStrategy;
            return this;
        }

        @Override
        public IBuildStage withValueExtractionStrategy(Function<CredentialRecord, String> valueExtractionStrategy) {
            this.valueExtractionStrategyBuild = valueExtractionStrategy;
            return this;
        }

        @Override
        public CacheServiceImpl build() {
            return new CacheServiceImpl(this);
        }
    }

    public static interface IBuildStage {
        public IBuildStage withKeyExtractionStrategy(Function<CredentialRecord, String> var1);

        public IBuildStage withLookupKeyExtractionStrategy(Function<ByteArray, String> var1);

        public IBuildStage withValueExtractionStrategy(Function<CredentialRecord, String> var1);

        public CacheServiceImpl build();
    }

    public static interface IUserHandleMappingCacheStage {
        public IBuildStage withCache(@Nonnull Cache<String, String> var1);
    }
}

